import * as tslib_1 from "tslib";
import { isPlatformBrowser } from '@angular/common';
import { Inject, Injectable, InjectionToken, Optional, PLATFORM_ID, } from '@angular/core';
import { BehaviorSubject, of } from 'rxjs';
export var RECAPTCHA_LANGUAGE = new InjectionToken('recaptcha-language');
export var RECAPTCHA_BASE_URL = new InjectionToken('recaptcha-base-url');
export var RECAPTCHA_NONCE = new InjectionToken('recaptcha-nonce-tag');
export function loadScript(renderMode, onLoaded, urlParams, url, nonce) {
    window.ng2recaptchaloaded = function () {
        onLoaded(grecaptcha);
    };
    var script = document.createElement('script');
    script.innerHTML = '';
    var baseUrl = url || 'https://www.google.com/recaptcha/api.js';
    script.src = baseUrl + "?render=" + renderMode + "&onload=ng2recaptchaloaded" + urlParams;
    if (nonce) {
        // tslint:disable-next-line:no-any Remove "any" cast once we upgrade Angular to 7 and TypeScript along with it
        script.nonce = nonce;
    }
    script.async = true;
    script.defer = true;
    document.head.appendChild(script);
}
var RecaptchaLoaderService = /** @class */ (function () {
    function RecaptchaLoaderService(
    // tslint:disable-next-line:no-any
    platformId, language, baseUrl, nonce) {
        this.platformId = platformId;
        this.language = language;
        this.baseUrl = baseUrl;
        this.nonce = nonce;
        this.init();
        this.ready = isPlatformBrowser(this.platformId) ? RecaptchaLoaderService_1.ready.asObservable() : of();
    }
    RecaptchaLoaderService_1 = RecaptchaLoaderService;
    /** @internal */
    RecaptchaLoaderService.prototype.init = function () {
        if (RecaptchaLoaderService_1.ready) {
            return;
        }
        if (isPlatformBrowser(this.platformId)) {
            var subject_1 = new BehaviorSubject(null);
            RecaptchaLoaderService_1.ready = subject_1;
            var langParam = this.language ? '&hl=' + this.language : '';
            loadScript('explicit', function (grecaptcha) { return subject_1.next(grecaptcha); }, langParam, this.baseUrl, this.nonce);
        }
    };
    /**
     * @internal
     * @nocollapse
     */
    RecaptchaLoaderService.ready = null;
    RecaptchaLoaderService = RecaptchaLoaderService_1 = tslib_1.__decorate([
        Injectable(),
        tslib_1.__param(0, Inject(PLATFORM_ID)),
        tslib_1.__param(1, Optional()), tslib_1.__param(1, Inject(RECAPTCHA_LANGUAGE)),
        tslib_1.__param(2, Optional()), tslib_1.__param(2, Inject(RECAPTCHA_BASE_URL)),
        tslib_1.__param(3, Optional()), tslib_1.__param(3, Inject(RECAPTCHA_NONCE)),
        tslib_1.__metadata("design:paramtypes", [Object, String, String, String])
    ], RecaptchaLoaderService);
    return RecaptchaLoaderService;
    var RecaptchaLoaderService_1;
}());
export { RecaptchaLoaderService };
//# sourceMappingURL=data:application/json;base64,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