import * as tslib_1 from "tslib";
import { isPlatformBrowser } from '@angular/common';
import { Inject, Injectable, InjectionToken, Optional, PLATFORM_ID, } from '@angular/core';
import { BehaviorSubject, of } from 'rxjs';
export const RECAPTCHA_LANGUAGE = new InjectionToken('recaptcha-language');
export const RECAPTCHA_BASE_URL = new InjectionToken('recaptcha-base-url');
export const RECAPTCHA_NONCE = new InjectionToken('recaptcha-nonce-tag');
export function loadScript(renderMode, onLoaded, urlParams, url, nonce) {
    window.ng2recaptchaloaded = () => {
        onLoaded(grecaptcha);
    };
    const script = document.createElement('script');
    script.innerHTML = '';
    const baseUrl = url || 'https://www.google.com/recaptcha/api.js';
    script.src = `${baseUrl}?render=${renderMode}&onload=ng2recaptchaloaded${urlParams}`;
    if (nonce) {
        // tslint:disable-next-line:no-any Remove "any" cast once we upgrade Angular to 7 and TypeScript along with it
        script.nonce = nonce;
    }
    script.async = true;
    script.defer = true;
    document.head.appendChild(script);
}
let RecaptchaLoaderService = RecaptchaLoaderService_1 = class RecaptchaLoaderService {
    constructor(
    // tslint:disable-next-line:no-any
    platformId, language, baseUrl, nonce) {
        this.platformId = platformId;
        this.language = language;
        this.baseUrl = baseUrl;
        this.nonce = nonce;
        this.init();
        this.ready = isPlatformBrowser(this.platformId) ? RecaptchaLoaderService_1.ready.asObservable() : of();
    }
    /** @internal */
    init() {
        if (RecaptchaLoaderService_1.ready) {
            return;
        }
        if (isPlatformBrowser(this.platformId)) {
            const subject = new BehaviorSubject(null);
            RecaptchaLoaderService_1.ready = subject;
            const langParam = this.language ? '&hl=' + this.language : '';
            loadScript('explicit', (grecaptcha) => subject.next(grecaptcha), langParam, this.baseUrl, this.nonce);
        }
    }
};
/**
 * @internal
 * @nocollapse
 */
RecaptchaLoaderService.ready = null;
RecaptchaLoaderService = RecaptchaLoaderService_1 = tslib_1.__decorate([
    Injectable(),
    tslib_1.__param(0, Inject(PLATFORM_ID)),
    tslib_1.__param(1, Optional()), tslib_1.__param(1, Inject(RECAPTCHA_LANGUAGE)),
    tslib_1.__param(2, Optional()), tslib_1.__param(2, Inject(RECAPTCHA_BASE_URL)),
    tslib_1.__param(3, Optional()), tslib_1.__param(3, Inject(RECAPTCHA_NONCE)),
    tslib_1.__metadata("design:paramtypes", [Object, String, String, String])
], RecaptchaLoaderService);
export { RecaptchaLoaderService };
var RecaptchaLoaderService_1;
//# sourceMappingURL=data:application/json;base64,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