"use strict";
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
function mapObject(obj, mapper) {
    return Object.keys(obj).reduce((acc, k) => {
        acc[k] = mapper(k, obj[k]);
        return acc;
    }, {});
}
exports.mapObject = mapObject;
const copySymbol = Symbol();
// tslint:disable-next-line:no-any
function deepCopy(value) {
    if (Array.isArray(value)) {
        return value.map((o) => deepCopy(o));
    }
    else if (value && typeof value === 'object') {
        if (value[copySymbol]) {
            // This is a circular dependency. Just return the cloned value.
            return value[copySymbol];
        }
        if (value['toJSON']) {
            return JSON.parse(value['toJSON']());
        }
        const copy = new (Object.getPrototypeOf(value).constructor)();
        value[copySymbol] = copy;
        for (const key of Object.getOwnPropertyNames(value)) {
            copy[key] = deepCopy(value[key]);
        }
        value[copySymbol] = undefined;
        return copy;
    }
    else {
        return value;
    }
}
exports.deepCopy = deepCopy;
//# sourceMappingURL=data:application/json;base64,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