(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('tslib'), require('@angular/core'), require('rxjs'), require('rxjs/operators')) :
    typeof define === 'function' && define.amd ? define('@ngx-translate/core', ['exports', 'tslib', '@angular/core', 'rxjs', 'rxjs/operators'], factory) :
    (factory((global['ngx-translate'] = global['ngx-translate'] || {}, global['ngx-translate'].core = {}),global.tslib,global.ng.core,global.rxjs,global.Rx.Observable.prototype));
}(this, (function (exports,tslib,core,rxjs,operators) { 'use strict';

    /**
     * @abstract
     */
    var TranslateLoader = (function () {
        function TranslateLoader() {
        }
        return TranslateLoader;
    }());
    /**
     * This loader is just a placeholder that does nothing, in case you don't need a loader at all
     */
    var TranslateFakeLoader = (function (_super) {
        tslib.__extends(TranslateFakeLoader, _super);
        function TranslateFakeLoader() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        /**
         * @param {?} lang
         * @return {?}
         */
        TranslateFakeLoader.prototype.getTranslation = function (lang) {
            return rxjs.of({});
        };
        return TranslateFakeLoader;
    }(TranslateLoader));
    TranslateFakeLoader.decorators = [
        { type: core.Injectable },
    ];
    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /**
     * @abstract
     */
    var MissingTranslationHandler = (function () {
        function MissingTranslationHandler() {
        }
        return MissingTranslationHandler;
    }());
    /**
     * This handler is just a placeholder that does nothing, in case you don't need a missing translation handler at all
     */
    var FakeMissingTranslationHandler = (function () {
        function FakeMissingTranslationHandler() {
        }
        /**
         * @param {?} params
         * @return {?}
         */
        FakeMissingTranslationHandler.prototype.handle = function (params) {
            return params.key;
        };
        return FakeMissingTranslationHandler;
    }());
    FakeMissingTranslationHandler.decorators = [
        { type: core.Injectable },
    ];
    /**
     * @abstract
     */
    var TranslateCompiler = (function () {
        function TranslateCompiler() {
        }
        return TranslateCompiler;
    }());
    /**
     * This compiler is just a placeholder that does nothing, in case you don't need a compiler at all
     */
    var TranslateFakeCompiler = (function (_super) {
        tslib.__extends(TranslateFakeCompiler, _super);
        function TranslateFakeCompiler() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        /**
         * @param {?} value
         * @param {?} lang
         * @return {?}
         */
        TranslateFakeCompiler.prototype.compile = function (value, lang) {
            return value;
        };
        /**
         * @param {?} translations
         * @param {?} lang
         * @return {?}
         */
        TranslateFakeCompiler.prototype.compileTranslations = function (translations, lang) {
            return translations;
        };
        return TranslateFakeCompiler;
    }(TranslateCompiler));
    TranslateFakeCompiler.decorators = [
        { type: core.Injectable },
    ];
    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /**
     * Determines if two objects or two values are equivalent.
     *
     * Two objects or values are considered equivalent if at least one of the following is true:
     *
     * * Both objects or values pass `===` comparison.
     * * Both objects or values are of the same type and all of their properties are equal by
     *   comparing them with `equals`.
     *
     * @param {?} o1 Object or value to compare.
     * @param {?} o2 Object or value to compare.
     * @return {?} true if arguments are equal.
     */
    function equals(o1, o2) {
        if (o1 === o2)
            return true;
        if (o1 === null || o2 === null)
            return false;
        if (o1 !== o1 && o2 !== o2)
            return true; // NaN === NaN
        var /** @type {?} */ t1 = typeof o1, /** @type {?} */ t2 = typeof o2, /** @type {?} */ length, /** @type {?} */ key, /** @type {?} */ keySet;
        if (t1 == t2 && t1 == 'object') {
            if (Array.isArray(o1)) {
                if (!Array.isArray(o2))
                    return false;
                if ((length = o1.length) == o2.length) {
                    for (key = 0; key < length; key++) {
                        if (!equals(o1[key], o2[key]))
                            return false;
                    }
                    return true;
                }
            }
            else {
                if (Array.isArray(o2)) {
                    return false;
                }
                keySet = Object.create(null);
                for (key in o1) {
                    if (!equals(o1[key], o2[key])) {
                        return false;
                    }
                    keySet[key] = true;
                }
                for (key in o2) {
                    if (!(key in keySet) && typeof o2[key] !== 'undefined') {
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }
    /**
     * @param {?} value
     * @return {?}
     */
    function isDefined(value) {
        return typeof value !== 'undefined' && value !== null;
    }
    /**
     * @param {?} item
     * @return {?}
     */
    function isObject(item) {
        return (item && typeof item === 'object' && !Array.isArray(item));
    }
    /**
     * @param {?} target
     * @param {?} source
     * @return {?}
     */
    function mergeDeep(target, source) {
        var /** @type {?} */ output = Object.assign({}, target);
        if (isObject(target) && isObject(source)) {
            Object.keys(source).forEach(function (key) {
                if (isObject(source[key])) {
                    if (!(key in target)) {
                        Object.assign(output, (_a = {}, _a[key] = source[key], _a));
                    }
                    else {
                        output[key] = mergeDeep(target[key], source[key]);
                    }
                }
                else {
                    Object.assign(output, (_b = {}, _b[key] = source[key], _b));
                }
                var _a, _b;
            });
        }
        return output;
    }
    /**
     * @abstract
     */
    var TranslateParser = (function () {
        function TranslateParser() {
        }
        return TranslateParser;
    }());
    var TranslateDefaultParser = (function (_super) {
        tslib.__extends(TranslateDefaultParser, _super);
        function TranslateDefaultParser() {
            var _this = _super.apply(this, tslib.__spread(arguments)) || this;
            _this.templateMatcher = /{{\s?([^{}\s]*)\s?}}/g;
            return _this;
        }
        /**
         * @param {?} expr
         * @param {?=} params
         * @return {?}
         */
        TranslateDefaultParser.prototype.interpolate = function (expr, params) {
            var /** @type {?} */ result;
            if (typeof expr === 'string') {
                result = this.interpolateString(expr, params);
            }
            else if (typeof expr === 'function') {
                result = this.interpolateFunction(expr, params);
            }
            else {
                // this should not happen, but an unrelated TranslateService test depends on it
                result = /** @type {?} */ (expr);
            }
            return result;
        };
        /**
         * @param {?} target
         * @param {?} key
         * @return {?}
         */
        TranslateDefaultParser.prototype.getValue = function (target, key) {
            var /** @type {?} */ keys = key.split('.');
            key = '';
            do {
                key += keys.shift();
                if (isDefined(target) && isDefined(target[key]) && (typeof target[key] === 'object' || !keys.length)) {
                    target = target[key];
                    key = '';
                }
                else if (!keys.length) {
                    target = undefined;
                }
                else {
                    key += '.';
                }
            } while (keys.length);
            return target;
        };
        /**
         * @param {?} fn
         * @param {?=} params
         * @return {?}
         */
        TranslateDefaultParser.prototype.interpolateFunction = function (fn, params) {
            return fn(params);
        };
        /**
         * @param {?} expr
         * @param {?=} params
         * @return {?}
         */
        TranslateDefaultParser.prototype.interpolateString = function (expr, params) {
            var _this = this;
            if (!params) {
                return expr;
            }
            return expr.replace(this.templateMatcher, function (substring, b) {
                var /** @type {?} */ r = _this.getValue(params, b);
                return isDefined(r) ? r : substring;
            });
        };
        return TranslateDefaultParser;
    }(TranslateParser));
    TranslateDefaultParser.decorators = [
        { type: core.Injectable },
    ];
    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var TranslateStore = (function () {
        function TranslateStore() {
            /**
             * The lang currently used
             */
            this.currentLang = this.defaultLang;
            /**
             * a list of translations per lang
             */
            this.translations = {};
            /**
             * an array of langs
             */
            this.langs = [];
            /**
             * An EventEmitter to listen to translation change events
             * onTranslationChange.subscribe((params: TranslationChangeEvent) => {
             *     // do something
             * });
             */
            this.onTranslationChange = new core.EventEmitter();
            /**
             * An EventEmitter to listen to lang change events
             * onLangChange.subscribe((params: LangChangeEvent) => {
             *     // do something
             * });
             */
            this.onLangChange = new core.EventEmitter();
            /**
             * An EventEmitter to listen to default lang change events
             * onDefaultLangChange.subscribe((params: DefaultLangChangeEvent) => {
             *     // do something
             * });
             */
            this.onDefaultLangChange = new core.EventEmitter();
        }
        return TranslateStore;
    }());
    var /** @type {?} */ USE_STORE = new core.InjectionToken('USE_STORE');
    var /** @type {?} */ USE_DEFAULT_LANG = new core.InjectionToken('USE_DEFAULT_LANG');
    var TranslateService = (function () {
        /**
         *
         * @param {?} store an instance of the store (that is supposed to be unique)
         * @param {?} currentLoader An instance of the loader currently used
         * @param {?} compiler An instance of the compiler currently used
         * @param {?} parser An instance of the parser currently used
         * @param {?} missingTranslationHandler A handler for missing translations.
         * @param {?=} useDefaultLang whether we should use default language translation when current language translation is missing.
         * @param {?=} isolate whether this service should use the store or not
         */
        function TranslateService(store, currentLoader, compiler, parser, missingTranslationHandler, useDefaultLang, isolate) {
            if (useDefaultLang === void 0) {
                useDefaultLang = true;
            }
            if (isolate === void 0) {
                isolate = false;
            }
            this.store = store;
            this.currentLoader = currentLoader;
            this.compiler = compiler;
            this.parser = parser;
            this.missingTranslationHandler = missingTranslationHandler;
            this.useDefaultLang = useDefaultLang;
            this.isolate = isolate;
            this.pending = false;
            this._onTranslationChange = new core.EventEmitter();
            this._onLangChange = new core.EventEmitter();
            this._onDefaultLangChange = new core.EventEmitter();
            this._langs = [];
            this._translations = {};
            this._translationRequests = {};
        }
        Object.defineProperty(TranslateService.prototype, "onTranslationChange", {
            /**
             * An EventEmitter to listen to translation change events
             * onTranslationChange.subscribe((params: TranslationChangeEvent) => {
             *     // do something
             * });
             * @return {?}
             */
            get: function () {
                return this.isolate ? this._onTranslationChange : this.store.onTranslationChange;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TranslateService.prototype, "onLangChange", {
            /**
             * An EventEmitter to listen to lang change events
             * onLangChange.subscribe((params: LangChangeEvent) => {
             *     // do something
             * });
             * @return {?}
             */
            get: function () {
                return this.isolate ? this._onLangChange : this.store.onLangChange;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TranslateService.prototype, "onDefaultLangChange", {
            /**
             * An EventEmitter to listen to default lang change events
             * onDefaultLangChange.subscribe((params: DefaultLangChangeEvent) => {
             *     // do something
             * });
             * @return {?}
             */
            get: function () {
                return this.isolate ? this._onDefaultLangChange : this.store.onDefaultLangChange;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TranslateService.prototype, "defaultLang", {
            /**
             * The default lang to fallback when translations are missing on the current lang
             * @return {?}
             */
            get: function () {
                return this.isolate ? this._defaultLang : this.store.defaultLang;
            },
            /**
             * @param {?} defaultLang
             * @return {?}
             */
            set: function (defaultLang) {
                if (this.isolate) {
                    this._defaultLang = defaultLang;
                }
                else {
                    this.store.defaultLang = defaultLang;
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TranslateService.prototype, "currentLang", {
            /**
             * The lang currently used
             * @return {?}
             */
            get: function () {
                return this.isolate ? this._currentLang : this.store.currentLang;
            },
            /**
             * @param {?} currentLang
             * @return {?}
             */
            set: function (currentLang) {
                if (this.isolate) {
                    this._currentLang = currentLang;
                }
                else {
                    this.store.currentLang = currentLang;
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TranslateService.prototype, "langs", {
            /**
             * an array of langs
             * @return {?}
             */
            get: function () {
                return this.isolate ? this._langs : this.store.langs;
            },
            /**
             * @param {?} langs
             * @return {?}
             */
            set: function (langs) {
                if (this.isolate) {
                    this._langs = langs;
                }
                else {
                    this.store.langs = langs;
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TranslateService.prototype, "translations", {
            /**
             * a list of translations per lang
             * @return {?}
             */
            get: function () {
                return this.isolate ? this._translations : this.store.translations;
            },
            /**
             * @param {?} translations
             * @return {?}
             */
            set: function (translations) {
                if (this.isolate) {
                    this._translations = translations;
                }
                else {
                    this.store.translations = translations;
                }
            },
            enumerable: true,
            configurable: true
        });
        /**
         * Sets the default language to use as a fallback
         * @param {?} lang
         * @return {?}
         */
        TranslateService.prototype.setDefaultLang = function (lang) {
            var _this = this;
            if (lang === this.defaultLang) {
                return;
            }
            var /** @type {?} */ pending = this.retrieveTranslations(lang);
            if (typeof pending !== "undefined") {
                // on init set the defaultLang immediately
                if (!this.defaultLang) {
                    this.defaultLang = lang;
                }
                pending.pipe(operators.take(1))
                    .subscribe(function (res) {
                    _this.changeDefaultLang(lang);
                });
            }
            else {
                // we already have this language
                this.changeDefaultLang(lang);
            }
        };
        /**
         * Gets the default language used
         * @return {?}
         */
        TranslateService.prototype.getDefaultLang = function () {
            return this.defaultLang;
        };
        /**
         * Changes the lang currently used
         * @param {?} lang
         * @return {?}
         */
        TranslateService.prototype.use = function (lang) {
            var _this = this;
            // don't change the language if the language given is already selected
            if (lang === this.currentLang) {
                return rxjs.of(this.translations[lang]);
            }
            var /** @type {?} */ pending = this.retrieveTranslations(lang);
            if (typeof pending !== "undefined") {
                // on init set the currentLang immediately
                if (!this.currentLang) {
                    this.currentLang = lang;
                }
                pending.pipe(operators.take(1))
                    .subscribe(function (res) {
                    _this.changeLang(lang);
                });
                return pending;
            }
            else {
                // we have this language, return an Observable
                this.changeLang(lang);
                return rxjs.of(this.translations[lang]);
            }
        };
        /**
         * Retrieves the given translations
         * @param {?} lang
         * @return {?}
         */
        TranslateService.prototype.retrieveTranslations = function (lang) {
            var /** @type {?} */ pending;
            // if this language is unavailable, ask for it
            if (typeof this.translations[lang] === "undefined") {
                this._translationRequests[lang] = this._translationRequests[lang] || this.getTranslation(lang);
                pending = this._translationRequests[lang];
            }
            return pending;
        };
        /**
         * Gets an object of translations for a given language with the current loader
         * and passes it through the compiler
         * @param {?} lang
         * @return {?}
         */
        TranslateService.prototype.getTranslation = function (lang) {
            var _this = this;
            this.pending = true;
            this.loadingTranslations = this.currentLoader.getTranslation(lang).pipe(operators.share());
            this.loadingTranslations.pipe(operators.take(1))
                .subscribe(function (res) {
                _this.translations[lang] = _this.compiler.compileTranslations(res, lang);
                _this.updateLangs();
                _this.pending = false;
            }, function (err) {
                _this.pending = false;
            });
            return this.loadingTranslations;
        };
        /**
         * Manually sets an object of translations for a given language
         * after passing it through the compiler
         * @param {?} lang
         * @param {?} translations
         * @param {?=} shouldMerge
         * @return {?}
         */
        TranslateService.prototype.setTranslation = function (lang, translations, shouldMerge) {
            if (shouldMerge === void 0) {
                shouldMerge = false;
            }
            translations = this.compiler.compileTranslations(translations, lang);
            if (shouldMerge && this.translations[lang]) {
                this.translations[lang] = mergeDeep(this.translations[lang], translations);
            }
            else {
                this.translations[lang] = translations;
            }
            this.updateLangs();
            this.onTranslationChange.emit({ lang: lang, translations: this.translations[lang] });
        };
        /**
         * Returns an array of currently available langs
         * @return {?}
         */
        TranslateService.prototype.getLangs = function () {
            return this.langs;
        };
        /**
         * Add available langs
         * @param {?} langs
         * @return {?}
         */
        TranslateService.prototype.addLangs = function (langs) {
            var _this = this;
            langs.forEach(function (lang) {
                if (_this.langs.indexOf(lang) === -1) {
                    _this.langs.push(lang);
                }
            });
        };
        /**
         * Update the list of available langs
         * @return {?}
         */
        TranslateService.prototype.updateLangs = function () {
            this.addLangs(Object.keys(this.translations));
        };
        /**
         * Returns the parsed result of the translations
         * @param {?} translations
         * @param {?} key
         * @param {?=} interpolateParams
         * @return {?}
         */
        TranslateService.prototype.getParsedResult = function (translations, key, interpolateParams) {
            var /** @type {?} */ res;
            if (key instanceof Array) {
                var /** @type {?} */ result = {}, /** @type {?} */ observables = false;
                try {
                    for (var key_1 = tslib.__values(key), key_1_1 = key_1.next(); !key_1_1.done; key_1_1 = key_1.next()) {
                        var k = key_1_1.value;
                        result[k] = this.getParsedResult(translations, k, interpolateParams);
                        if (typeof result[k].subscribe === "function") {
                            observables = true;
                        }
                    }
                }
                catch (e_1_1) {
                    e_1 = { error: e_1_1 };
                }
                finally {
                    try {
                        if (key_1_1 && !key_1_1.done && (_a = key_1.return))
                            _a.call(key_1);
                    }
                    finally {
                        if (e_1)
                            throw e_1.error;
                    }
                }
                if (observables) {
                    var /** @type {?} */ mergedObs = void 0;
                    try {
                        for (var key_2 = tslib.__values(key), key_2_1 = key_2.next(); !key_2_1.done; key_2_1 = key_2.next()) {
                            var k = key_2_1.value;
                            var /** @type {?} */ obs = typeof result[k].subscribe === "function" ? result[k] : rxjs.of(/** @type {?} */ (result[k]));
                            if (typeof mergedObs === "undefined") {
                                mergedObs = obs;
                            }
                            else {
                                mergedObs = rxjs.merge(mergedObs, obs);
                            }
                        }
                    }
                    catch (e_2_1) {
                        e_2 = { error: e_2_1 };
                    }
                    finally {
                        try {
                            if (key_2_1 && !key_2_1.done && (_b = key_2.return))
                                _b.call(key_2);
                        }
                        finally {
                            if (e_2)
                                throw e_2.error;
                        }
                    }
                    return mergedObs.pipe(operators.toArray(), operators.map(function (arr) {
                        var /** @type {?} */ obj = {};
                        arr.forEach(function (value, index) {
                            obj[key[index]] = value;
                        });
                        return obj;
                    }));
                }
                return result;
            }
            if (translations) {
                res = this.parser.interpolate(this.parser.getValue(translations, key), interpolateParams);
            }
            if (typeof res === "undefined" && this.defaultLang && this.defaultLang !== this.currentLang && this.useDefaultLang) {
                res = this.parser.interpolate(this.parser.getValue(this.translations[this.defaultLang], key), interpolateParams);
            }
            if (typeof res === "undefined") {
                var /** @type {?} */ params = { key: key, translateService: this };
                if (typeof interpolateParams !== 'undefined') {
                    params.interpolateParams = interpolateParams;
                }
                res = this.missingTranslationHandler.handle(params);
            }
            return typeof res !== "undefined" ? res : key;
            var e_1, _a, e_2, _b;
        };
        /**
         * Gets the translated value of a key (or an array of keys)
         * @param {?} key
         * @param {?=} interpolateParams
         * @return {?} the translated key, or an object of translated keys
         */
        TranslateService.prototype.get = function (key, interpolateParams) {
            var _this = this;
            if (!isDefined(key) || !key.length) {
                throw new Error("Parameter \"key\" required");
            }
            // check if we are loading a new translation to use
            if (this.pending) {
                return rxjs.Observable.create(function (observer) {
                    var /** @type {?} */ onComplete = function (res) {
                        observer.next(res);
                        observer.complete();
                    };
                    var /** @type {?} */ onError = function (err) {
                        observer.error(err);
                    };
                    _this.loadingTranslations.subscribe(function (res) {
                        res = _this.getParsedResult(_this.compiler.compileTranslations(res, _this.currentLang), key, interpolateParams);
                        if (typeof res.subscribe === "function") {
                            res.subscribe(onComplete, onError);
                        }
                        else {
                            onComplete(res);
                        }
                    }, onError);
                });
            }
            else {
                var /** @type {?} */ res = this.getParsedResult(this.translations[this.currentLang], key, interpolateParams);
                if (typeof res.subscribe === "function") {
                    return res;
                }
                else {
                    return rxjs.of(res);
                }
            }
        };
        /**
         * Returns a stream of translated values of a key (or an array of keys) which updates
         * whenever the language changes.
         * @param {?} key
         * @param {?=} interpolateParams
         * @return {?} A stream of the translated key, or an object of translated keys
         */
        TranslateService.prototype.stream = function (key, interpolateParams) {
            var _this = this;
            if (!isDefined(key) || !key.length) {
                throw new Error("Parameter \"key\" required");
            }
            return rxjs.concat(this.get(key, interpolateParams), this.onLangChange.pipe(operators.switchMap(function (event) {
                var /** @type {?} */ res = _this.getParsedResult(event.translations, key, interpolateParams);
                if (typeof res.subscribe === "function") {
                    return res;
                }
                else {
                    return rxjs.of(res);
                }
            })));
        };
        /**
         * Returns a translation instantly from the internal state of loaded translation.
         * All rules regarding the current language, the preferred language of even fallback languages will be used except any promise handling.
         * @param {?} key
         * @param {?=} interpolateParams
         * @return {?}
         */
        TranslateService.prototype.instant = function (key, interpolateParams) {
            if (!isDefined(key) || !key.length) {
                throw new Error("Parameter \"key\" required");
            }
            var /** @type {?} */ res = this.getParsedResult(this.translations[this.currentLang], key, interpolateParams);
            if (typeof res.subscribe !== "undefined") {
                if (key instanceof Array) {
                    var /** @type {?} */ obj_1 = {};
                    key.forEach(function (value, index) {
                        obj_1[key[index]] = key[index];
                    });
                    return obj_1;
                }
                return key;
            }
            else {
                return res;
            }
        };
        /**
         * Sets the translated value of a key, after compiling it
         * @param {?} key
         * @param {?} value
         * @param {?=} lang
         * @return {?}
         */
        TranslateService.prototype.set = function (key, value, lang) {
            if (lang === void 0) {
                lang = this.currentLang;
            }
            this.translations[lang][key] = this.compiler.compile(value, lang);
            this.updateLangs();
            this.onTranslationChange.emit({ lang: lang, translations: this.translations[lang] });
        };
        /**
         * Changes the current lang
         * @param {?} lang
         * @return {?}
         */
        TranslateService.prototype.changeLang = function (lang) {
            this.currentLang = lang;
            this.onLangChange.emit({ lang: lang, translations: this.translations[lang] });
            // if there is no default lang, use the one that we just set
            if (!this.defaultLang) {
                this.changeDefaultLang(lang);
            }
        };
        /**
         * Changes the default lang
         * @param {?} lang
         * @return {?}
         */
        TranslateService.prototype.changeDefaultLang = function (lang) {
            this.defaultLang = lang;
            this.onDefaultLangChange.emit({ lang: lang, translations: this.translations[lang] });
        };
        /**
         * Allows to reload the lang file from the file
         * @param {?} lang
         * @return {?}
         */
        TranslateService.prototype.reloadLang = function (lang) {
            this.resetLang(lang);
            return this.getTranslation(lang);
        };
        /**
         * Deletes inner translation
         * @param {?} lang
         * @return {?}
         */
        TranslateService.prototype.resetLang = function (lang) {
            this._translationRequests[lang] = undefined;
            this.translations[lang] = undefined;
        };
        /**
         * Returns the language code name from the browser, e.g. "de"
         * @return {?}
         */
        TranslateService.prototype.getBrowserLang = function () {
            if (typeof window === 'undefined' || typeof window.navigator === 'undefined') {
                return undefined;
            }
            var /** @type {?} */ browserLang = window.navigator.languages ? window.navigator.languages[0] : null;
            browserLang = browserLang || window.navigator.language || window.navigator.browserLanguage || window.navigator.userLanguage;
            if (browserLang.indexOf('-') !== -1) {
                browserLang = browserLang.split('-')[0];
            }
            if (browserLang.indexOf('_') !== -1) {
                browserLang = browserLang.split('_')[0];
            }
            return browserLang;
        };
        /**
         * Returns the culture language code name from the browser, e.g. "de-DE"
         * @return {?}
         */
        TranslateService.prototype.getBrowserCultureLang = function () {
            if (typeof window === 'undefined' || typeof window.navigator === 'undefined') {
                return undefined;
            }
            var /** @type {?} */ browserCultureLang = window.navigator.languages ? window.navigator.languages[0] : null;
            browserCultureLang = browserCultureLang || window.navigator.language || window.navigator.browserLanguage || window.navigator.userLanguage;
            return browserCultureLang;
        };
        return TranslateService;
    }());
    TranslateService.decorators = [
        { type: core.Injectable },
    ];
    /** @nocollapse */
    TranslateService.ctorParameters = function () {
        return [
            { type: TranslateStore, },
            { type: TranslateLoader, },
            { type: TranslateCompiler, },
            { type: TranslateParser, },
            { type: MissingTranslationHandler, },
            { type: undefined, decorators: [{ type: core.Inject, args: [USE_DEFAULT_LANG,] },] },
            { type: undefined, decorators: [{ type: core.Inject, args: [USE_STORE,] },] },
        ];
    };
    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var TranslateDirective = (function () {
        /**
         * @param {?} translateService
         * @param {?} element
         * @param {?} _ref
         */
        function TranslateDirective(translateService, element, _ref) {
            var _this = this;
            this.translateService = translateService;
            this.element = element;
            this._ref = _ref;
            // subscribe to onTranslationChange event, in case the translations of the current lang change
            if (!this.onTranslationChangeSub) {
                this.onTranslationChangeSub = this.translateService.onTranslationChange.subscribe(function (event) {
                    if (event.lang === _this.translateService.currentLang) {
                        _this.checkNodes(true, event.translations);
                    }
                });
            }
            // subscribe to onLangChange event, in case the language changes
            if (!this.onLangChangeSub) {
                this.onLangChangeSub = this.translateService.onLangChange.subscribe(function (event) {
                    _this.checkNodes(true, event.translations);
                });
            }
            // subscribe to onDefaultLangChange event, in case the default language changes
            if (!this.onDefaultLangChangeSub) {
                this.onDefaultLangChangeSub = this.translateService.onDefaultLangChange.subscribe(function (event) {
                    _this.checkNodes(true);
                });
            }
        }
        Object.defineProperty(TranslateDirective.prototype, "translate", {
            /**
             * @param {?} key
             * @return {?}
             */
            set: function (key) {
                if (key) {
                    this.key = key;
                    this.checkNodes();
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(TranslateDirective.prototype, "translateParams", {
            /**
             * @param {?} params
             * @return {?}
             */
            set: function (params) {
                if (!equals(this.currentParams, params)) {
                    this.currentParams = params;
                    this.checkNodes(true);
                }
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        TranslateDirective.prototype.ngAfterViewChecked = function () {
            this.checkNodes();
        };
        /**
         * @param {?=} forceUpdate
         * @param {?=} translations
         * @return {?}
         */
        TranslateDirective.prototype.checkNodes = function (forceUpdate, translations) {
            if (forceUpdate === void 0) {
                forceUpdate = false;
            }
            var /** @type {?} */ nodes = this.element.nativeElement.childNodes;
            // if the element is empty
            if (!nodes.length) {
                // we add the key as content
                this.setContent(this.element.nativeElement, this.key);
                nodes = this.element.nativeElement.childNodes;
            }
            for (var /** @type {?} */ i = 0; i < nodes.length; ++i) {
                var /** @type {?} */ node = nodes[i];
                if (node.nodeType === 3) {
                    // node type 3 is a text node
                    var /** @type {?} */ key = void 0;
                    if (this.key) {
                        key = this.key;
                        if (forceUpdate) {
                            node.lastKey = null;
                        }
                    }
                    else {
                        var /** @type {?} */ content = this.getContent(node);
                        var /** @type {?} */ trimmedContent = content.trim();
                        if (trimmedContent.length) {
                            // we want to use the content as a key, not the translation value
                            if (content !== node.currentValue) {
                                key = trimmedContent;
                                // the content was changed from the user, we'll use it as a reference if needed
                                node.originalContent = this.getContent(node);
                            }
                            else if (node.originalContent && forceUpdate) {
                                // the content seems ok, but the lang has changed
                                node.lastKey = null;
                                // the current content is the translation, not the key, use the last real content as key
                                key = node.originalContent.trim();
                            }
                        }
                    }
                    this.updateValue(key, node, translations);
                }
            }
        };
        /**
         * @param {?} key
         * @param {?} node
         * @param {?} translations
         * @return {?}
         */
        TranslateDirective.prototype.updateValue = function (key, node, translations) {
            var _this = this;
            if (key) {
                if (node.lastKey === key && this.lastParams === this.currentParams) {
                    return;
                }
                this.lastParams = this.currentParams;
                var /** @type {?} */ onTranslation = function (res) {
                    if (res !== key) {
                        node.lastKey = key;
                    }
                    if (!node.originalContent) {
                        node.originalContent = _this.getContent(node);
                    }
                    node.currentValue = isDefined(res) ? res : (node.originalContent || key);
                    // we replace in the original content to preserve spaces that we might have trimmed
                    _this.setContent(node, _this.key ? node.currentValue : node.originalContent.replace(key, node.currentValue));
                    _this._ref.markForCheck();
                };
                if (isDefined(translations)) {
                    var /** @type {?} */ res = this.translateService.getParsedResult(translations, key, this.currentParams);
                    if (typeof res.subscribe === "function") {
                        res.subscribe(onTranslation);
                    }
                    else {
                        onTranslation(res);
                    }
                }
                else {
                    this.translateService.get(key, this.currentParams).subscribe(onTranslation);
                }
            }
        };
        /**
         * @param {?} node
         * @return {?}
         */
        TranslateDirective.prototype.getContent = function (node) {
            return isDefined(node.textContent) ? node.textContent : node.data;
        };
        /**
         * @param {?} node
         * @param {?} content
         * @return {?}
         */
        TranslateDirective.prototype.setContent = function (node, content) {
            if (isDefined(node.textContent)) {
                node.textContent = content;
            }
            else {
                node.data = content;
            }
        };
        /**
         * @return {?}
         */
        TranslateDirective.prototype.ngOnDestroy = function () {
            if (this.onLangChangeSub) {
                this.onLangChangeSub.unsubscribe();
            }
            if (this.onDefaultLangChangeSub) {
                this.onDefaultLangChangeSub.unsubscribe();
            }
            if (this.onTranslationChangeSub) {
                this.onTranslationChangeSub.unsubscribe();
            }
        };
        return TranslateDirective;
    }());
    TranslateDirective.decorators = [
        { type: core.Directive, args: [{
                    selector: '[translate],[ngx-translate]'
                },] },
    ];
    /** @nocollapse */
    TranslateDirective.ctorParameters = function () {
        return [
            { type: TranslateService, },
            { type: core.ElementRef, },
            { type: core.ChangeDetectorRef, },
        ];
    };
    TranslateDirective.propDecorators = {
        "translate": [{ type: core.Input },],
        "translateParams": [{ type: core.Input },],
    };
    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var TranslatePipe = (function () {
        /**
         * @param {?} translate
         * @param {?} _ref
         */
        function TranslatePipe(translate, _ref) {
            this.translate = translate;
            this._ref = _ref;
            this.value = '';
        }
        /**
         * @param {?} key
         * @param {?=} interpolateParams
         * @param {?=} translations
         * @return {?}
         */
        TranslatePipe.prototype.updateValue = function (key, interpolateParams, translations) {
            var _this = this;
            var /** @type {?} */ onTranslation = function (res) {
                _this.value = res !== undefined ? res : key;
                _this.lastKey = key;
                _this._ref.markForCheck();
            };
            if (translations) {
                var /** @type {?} */ res = this.translate.getParsedResult(translations, key, interpolateParams);
                if (typeof res.subscribe === 'function') {
                    res.subscribe(onTranslation);
                }
                else {
                    onTranslation(res);
                }
            }
            this.translate.get(key, interpolateParams).subscribe(onTranslation);
        };
        /**
         * @param {?} query
         * @param {...?} args
         * @return {?}
         */
        TranslatePipe.prototype.transform = function (query) {
            var _this = this;
            var args = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                args[_i - 1] = arguments[_i];
            }
            if (!query || query.length === 0) {
                return query;
            }
            // if we ask another time for the same key, return the last value
            if (equals(query, this.lastKey) && equals(args, this.lastParams)) {
                return this.value;
            }
            var /** @type {?} */ interpolateParams;
            if (isDefined(args[0]) && args.length) {
                if (typeof args[0] === 'string' && args[0].length) {
                    // we accept objects written in the template such as {n:1}, {'n':1}, {n:'v'}
                    // which is why we might need to change it to real JSON objects such as {"n":1} or {"n":"v"}
                    var /** @type {?} */ validArgs = args[0]
                        .replace(/(\')?([a-zA-Z0-9_]+)(\')?(\s)?:/g, '"$2":')
                        .replace(/:(\s)?(\')(.*?)(\')/g, ':"$3"');
                    try {
                        interpolateParams = JSON.parse(validArgs);
                    }
                    catch (e) {
                        throw new SyntaxError("Wrong parameter in TranslatePipe. Expected a valid Object, received: " + args[0]);
                    }
                }
                else if (typeof args[0] === 'object' && !Array.isArray(args[0])) {
                    interpolateParams = args[0];
                }
            }
            // store the query, in case it changes
            this.lastKey = query;
            // store the params, in case they change
            this.lastParams = args;
            // set the value
            this.updateValue(query, interpolateParams);
            // if there is a subscription to onLangChange, clean it
            this._dispose();
            // subscribe to onTranslationChange event, in case the translations change
            if (!this.onTranslationChange) {
                this.onTranslationChange = this.translate.onTranslationChange.subscribe(function (event) {
                    if (_this.lastKey && event.lang === _this.translate.currentLang) {
                        _this.lastKey = null;
                        _this.updateValue(query, interpolateParams, event.translations);
                    }
                });
            }
            // subscribe to onLangChange event, in case the language changes
            if (!this.onLangChange) {
                this.onLangChange = this.translate.onLangChange.subscribe(function (event) {
                    if (_this.lastKey) {
                        _this.lastKey = null; // we want to make sure it doesn't return the same value until it's been updated
                        _this.updateValue(query, interpolateParams, event.translations);
                    }
                });
            }
            // subscribe to onDefaultLangChange event, in case the default language changes
            if (!this.onDefaultLangChange) {
                this.onDefaultLangChange = this.translate.onDefaultLangChange.subscribe(function () {
                    if (_this.lastKey) {
                        _this.lastKey = null; // we want to make sure it doesn't return the same value until it's been updated
                        _this.updateValue(query, interpolateParams);
                    }
                });
            }
            return this.value;
        };
        /**
         * Clean any existing subscription to change events
         * @return {?}
         */
        TranslatePipe.prototype._dispose = function () {
            if (typeof this.onTranslationChange !== 'undefined') {
                this.onTranslationChange.unsubscribe();
                this.onTranslationChange = undefined;
            }
            if (typeof this.onLangChange !== 'undefined') {
                this.onLangChange.unsubscribe();
                this.onLangChange = undefined;
            }
            if (typeof this.onDefaultLangChange !== 'undefined') {
                this.onDefaultLangChange.unsubscribe();
                this.onDefaultLangChange = undefined;
            }
        };
        /**
         * @return {?}
         */
        TranslatePipe.prototype.ngOnDestroy = function () {
            this._dispose();
        };
        return TranslatePipe;
    }());
    TranslatePipe.decorators = [
        { type: core.Injectable },
        { type: core.Pipe, args: [{
                    name: 'translate',
                    pure: false // required to update the value when the promise is resolved
                },] },
    ];
    /** @nocollapse */
    TranslatePipe.ctorParameters = function () {
        return [
            { type: TranslateService, },
            { type: core.ChangeDetectorRef, },
        ];
    };
    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var TranslateModule = (function () {
        function TranslateModule() {
        }
        /**
         * Use this method in your root module to provide the TranslateService
         * @param {?=} config
         * @return {?}
         */
        TranslateModule.forRoot = function (config) {
            if (config === void 0) {
                config = {};
            }
            return {
                ngModule: TranslateModule,
                providers: [
                    config.loader || { provide: TranslateLoader, useClass: TranslateFakeLoader },
                    config.compiler || { provide: TranslateCompiler, useClass: TranslateFakeCompiler },
                    config.parser || { provide: TranslateParser, useClass: TranslateDefaultParser },
                    config.missingTranslationHandler || { provide: MissingTranslationHandler, useClass: FakeMissingTranslationHandler },
                    TranslateStore,
                    { provide: USE_STORE, useValue: config.isolate },
                    { provide: USE_DEFAULT_LANG, useValue: config.useDefaultLang },
                    TranslateService
                ]
            };
        };
        /**
         * Use this method in your other (non root) modules to import the directive/pipe
         * @param {?=} config
         * @return {?}
         */
        TranslateModule.forChild = function (config) {
            if (config === void 0) {
                config = {};
            }
            return {
                ngModule: TranslateModule,
                providers: [
                    config.loader || { provide: TranslateLoader, useClass: TranslateFakeLoader },
                    config.compiler || { provide: TranslateCompiler, useClass: TranslateFakeCompiler },
                    config.parser || { provide: TranslateParser, useClass: TranslateDefaultParser },
                    config.missingTranslationHandler || { provide: MissingTranslationHandler, useClass: FakeMissingTranslationHandler },
                    { provide: USE_STORE, useValue: config.isolate },
                    { provide: USE_DEFAULT_LANG, useValue: config.useDefaultLang },
                    TranslateService
                ]
            };
        };
        return TranslateModule;
    }());
    TranslateModule.decorators = [
        { type: core.NgModule, args: [{
                    declarations: [
                        TranslatePipe,
                        TranslateDirective
                    ],
                    exports: [
                        TranslatePipe,
                        TranslateDirective
                    ]
                },] },
    ];

    exports.TranslateModule = TranslateModule;
    exports.TranslateLoader = TranslateLoader;
    exports.TranslateFakeLoader = TranslateFakeLoader;
    exports.USE_STORE = USE_STORE;
    exports.USE_DEFAULT_LANG = USE_DEFAULT_LANG;
    exports.TranslateService = TranslateService;
    exports.MissingTranslationHandler = MissingTranslationHandler;
    exports.FakeMissingTranslationHandler = FakeMissingTranslationHandler;
    exports.TranslateParser = TranslateParser;
    exports.TranslateDefaultParser = TranslateDefaultParser;
    exports.TranslateCompiler = TranslateCompiler;
    exports.TranslateFakeCompiler = TranslateFakeCompiler;
    exports.TranslateDirective = TranslateDirective;
    exports.TranslatePipe = TranslatePipe;
    exports.TranslateStore = TranslateStore;

    Object.defineProperty(exports, '__esModule', { value: true });

})));
//# sourceMappingURL=ngx-translate-core.umd.js.map
