/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,uselessCode} checked by tsc
 */
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import * as core from '@angular/core';
import { exportNgVar } from '../util';
/** @type {?} */
const CORE_TOKENS = {
    'ApplicationRef': core.ApplicationRef,
    'NgZone': core.NgZone,
};
/** @type {?} */
const INSPECT_GLOBAL_NAME = 'probe';
/** @type {?} */
const CORE_TOKENS_GLOBAL_NAME = 'coreTokens';
/**
 * Returns a {\@link DebugElement} for the given native DOM element, or
 * null if the given native element does not have an Angular view associated
 * with it.
 * @param {?} element
 * @return {?}
 */
export function inspectNativeElement(element) {
    return core.getDebugNode(element);
}
/**
 * @param {?} coreTokens
 * @return {?}
 */
export function _createNgProbe(coreTokens) {
    exportNgVar(INSPECT_GLOBAL_NAME, inspectNativeElement);
    exportNgVar(CORE_TOKENS_GLOBAL_NAME, Object.assign({}, CORE_TOKENS, _ngProbeTokensToMap(coreTokens || [])));
    return () => inspectNativeElement;
}
/**
 * @param {?} tokens
 * @return {?}
 */
function _ngProbeTokensToMap(tokens) {
    return tokens.reduce((prev, t) => (prev[t.name] = t.token, prev), {});
}
/** *
 * Providers which support debugging Angular applications (e.g. via `ng.probe`).
  @type {?} */
export const ELEMENT_PROBE_PROVIDERS = [
    {
        provide: core.APP_INITIALIZER,
        useFactory: _createNgProbe,
        deps: [
            [core.NgProbeToken, new core.Optional()],
        ],
        multi: true,
    },
];

//# sourceMappingURL=data:application/json;base64,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