/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,uselessCode} checked by tsc
 */
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { Identifiers, getUrlScheme, syntaxError } from '@angular/compiler';
import { ANALYZE_FOR_ENTRY_COMPONENTS, ChangeDetectionStrategy, ChangeDetectorRef, ComponentFactory, ComponentFactoryResolver, ComponentRef, ElementRef, Injector, LOCALE_ID, NgModuleFactory, NgModuleRef, QueryList, Renderer, SecurityContext, TRANSLATIONS_FORMAT, TemplateRef, ViewContainerRef, ViewEncapsulation, ɵCodegenComponentFactoryResolver, ɵEMPTY_ARRAY, ɵEMPTY_MAP, ɵReflectionCapabilities as ReflectionCapabilities, ɵand, ɵccf, ɵcmf, ɵcrt, ɵdid, ɵeld, ɵinlineInterpolate, ɵinterpolate, ɵmod, ɵmpd, ɵncd, ɵnov, ɵpad, ɵpid, ɵpod, ɵppd, ɵprd, ɵqud, ɵregisterModuleFactory, ɵstringify as stringify, ɵted, ɵunv, ɵvid } from '@angular/core';
/** @type {?} */
export const MODULE_SUFFIX = '';
/** @type {?} */
const builtinExternalReferences = createBuiltinExternalReferencesMap();
export class JitReflector {
    constructor() {
        this.builtinExternalReferences = new Map();
        this.reflectionCapabilities = new ReflectionCapabilities();
    }
    /**
     * @param {?} type
     * @param {?} cmpMetadata
     * @return {?}
     */
    componentModuleUrl(type, cmpMetadata) {
        /** @type {?} */
        const moduleId = cmpMetadata.moduleId;
        if (typeof moduleId === 'string') {
            /** @type {?} */
            const scheme = getUrlScheme(moduleId);
            return scheme ? moduleId : `package:${moduleId}${MODULE_SUFFIX}`;
        }
        else if (moduleId !== null && moduleId !== void 0) {
            throw syntaxError(`moduleId should be a string in "${stringify(type)}". See https://goo.gl/wIDDiL for more information.\n` +
                `If you're using Webpack you should inline the template and the styles, see https://goo.gl/X2J8zc.`);
        }
        return `./${stringify(type)}`;
    }
    /**
     * @param {?} typeOrFunc
     * @return {?}
     */
    parameters(typeOrFunc) {
        return this.reflectionCapabilities.parameters(typeOrFunc);
    }
    /**
     * @param {?} typeOrFunc
     * @return {?}
     */
    tryAnnotations(typeOrFunc) { return this.annotations(typeOrFunc); }
    /**
     * @param {?} typeOrFunc
     * @return {?}
     */
    annotations(typeOrFunc) {
        return this.reflectionCapabilities.annotations(typeOrFunc);
    }
    /**
     * @param {?} typeOrFunc
     * @return {?}
     */
    shallowAnnotations(typeOrFunc) {
        throw new Error('Not supported in JIT mode');
    }
    /**
     * @param {?} typeOrFunc
     * @return {?}
     */
    propMetadata(typeOrFunc) {
        return this.reflectionCapabilities.propMetadata(typeOrFunc);
    }
    /**
     * @param {?} type
     * @param {?} lcProperty
     * @return {?}
     */
    hasLifecycleHook(type, lcProperty) {
        return this.reflectionCapabilities.hasLifecycleHook(type, lcProperty);
    }
    /**
     * @param {?} type
     * @return {?}
     */
    guards(type) { return this.reflectionCapabilities.guards(type); }
    /**
     * @param {?} ref
     * @return {?}
     */
    resolveExternalReference(ref) {
        return builtinExternalReferences.get(ref) || ref.runtime;
    }
}
if (false) {
    /** @type {?} */
    JitReflector.prototype.reflectionCapabilities;
    /** @type {?} */
    JitReflector.prototype.builtinExternalReferences;
}
/**
 * @return {?}
 */
function createBuiltinExternalReferencesMap() {
    /** @type {?} */
    const map = new Map();
    map.set(Identifiers.ANALYZE_FOR_ENTRY_COMPONENTS, ANALYZE_FOR_ENTRY_COMPONENTS);
    map.set(Identifiers.ElementRef, ElementRef);
    map.set(Identifiers.NgModuleRef, NgModuleRef);
    map.set(Identifiers.ViewContainerRef, ViewContainerRef);
    map.set(Identifiers.ChangeDetectorRef, ChangeDetectorRef);
    map.set(Identifiers.QueryList, QueryList);
    map.set(Identifiers.TemplateRef, TemplateRef);
    map.set(Identifiers.CodegenComponentFactoryResolver, ɵCodegenComponentFactoryResolver);
    map.set(Identifiers.ComponentFactoryResolver, ComponentFactoryResolver);
    map.set(Identifiers.ComponentFactory, ComponentFactory);
    map.set(Identifiers.ComponentRef, ComponentRef);
    map.set(Identifiers.NgModuleFactory, NgModuleFactory);
    map.set(Identifiers.createModuleFactory, ɵcmf);
    map.set(Identifiers.moduleDef, ɵmod);
    map.set(Identifiers.moduleProviderDef, ɵmpd);
    map.set(Identifiers.RegisterModuleFactoryFn, ɵregisterModuleFactory);
    map.set(Identifiers.Injector, Injector);
    map.set(Identifiers.ViewEncapsulation, ViewEncapsulation);
    map.set(Identifiers.ChangeDetectionStrategy, ChangeDetectionStrategy);
    map.set(Identifiers.SecurityContext, SecurityContext);
    map.set(Identifiers.LOCALE_ID, LOCALE_ID);
    map.set(Identifiers.TRANSLATIONS_FORMAT, TRANSLATIONS_FORMAT);
    map.set(Identifiers.inlineInterpolate, ɵinlineInterpolate);
    map.set(Identifiers.interpolate, ɵinterpolate);
    map.set(Identifiers.EMPTY_ARRAY, ɵEMPTY_ARRAY);
    map.set(Identifiers.EMPTY_MAP, ɵEMPTY_MAP);
    map.set(Identifiers.Renderer, Renderer);
    map.set(Identifiers.viewDef, ɵvid);
    map.set(Identifiers.elementDef, ɵeld);
    map.set(Identifiers.anchorDef, ɵand);
    map.set(Identifiers.textDef, ɵted);
    map.set(Identifiers.directiveDef, ɵdid);
    map.set(Identifiers.providerDef, ɵprd);
    map.set(Identifiers.queryDef, ɵqud);
    map.set(Identifiers.pureArrayDef, ɵpad);
    map.set(Identifiers.pureObjectDef, ɵpod);
    map.set(Identifiers.purePipeDef, ɵppd);
    map.set(Identifiers.pipeDef, ɵpid);
    map.set(Identifiers.nodeValue, ɵnov);
    map.set(Identifiers.ngContentDef, ɵncd);
    map.set(Identifiers.unwrapValue, ɵunv);
    map.set(Identifiers.createRendererType2, ɵcrt);
    map.set(Identifiers.createComponentFactory, ɵccf);
    return map;
}

//# sourceMappingURL=data:application/json;base64,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