/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { syntaxError } from '../util';
var FORMATTED_MESSAGE = 'ngFormattedMessage';
function indentStr(level) {
    if (level <= 0)
        return '';
    if (level < 6)
        return ['', ' ', '  ', '   ', '    ', '     '][level];
    var half = indentStr(Math.floor(level / 2));
    return half + half + (level % 2 === 1 ? ' ' : '');
}
function formatChain(chain, indent) {
    if (indent === void 0) { indent = 0; }
    if (!chain)
        return '';
    var position = chain.position ?
        chain.position.fileName + "(" + (chain.position.line + 1) + "," + (chain.position.column + 1) + ")" :
        '';
    var prefix = position && indent === 0 ? position + ": " : '';
    var postfix = position && indent !== 0 ? " at " + position : '';
    var message = "" + prefix + chain.message + postfix;
    return "" + indentStr(indent) + message + ((chain.next && ('\n' + formatChain(chain.next, indent + 2))) || '');
}
export function formattedError(chain) {
    var message = formatChain(chain) + '.';
    var error = syntaxError(message);
    error[FORMATTED_MESSAGE] = true;
    error.chain = chain;
    error.position = chain.position;
    return error;
}
export function isFormattedError(error) {
    return !!error[FORMATTED_MESSAGE];
}
//# sourceMappingURL=data:application/json;base64,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