"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const node_module_engine_host_1 = require("./node-module-engine-host");
/**
 * An EngineHost that uses a registry to super seed locations of collection.json files, but
 * revert back to using node modules resolution. This is done for testing.
 */
class NodeModulesTestEngineHost extends node_module_engine_host_1.NodeModulesEngineHost {
    constructor() {
        super(...arguments);
        this._collections = new Map();
        this._tasks = [];
    }
    get tasks() { return this._tasks; }
    clearTasks() { this._tasks = []; }
    registerCollection(name, path) {
        this._collections.set(name, path);
    }
    transformContext(context) {
        const oldAddTask = context.addTask;
        context.addTask = (task, dependencies) => {
            this._tasks.push(task.toConfiguration());
            return oldAddTask.call(context, task, dependencies);
        };
        return context;
    }
    _resolveCollectionPath(name) {
        const maybePath = this._collections.get(name);
        if (maybePath) {
            return maybePath;
        }
        return super._resolveCollectionPath(name);
    }
}
exports.NodeModulesTestEngineHost = NodeModulesTestEngineHost;
//# sourceMappingURL=data:application/json;base64,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