"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
const path_1 = require("path");
class ExportStringRef {
    constructor(ref, parentPath = process.cwd(), inner = true) {
        const [path, name] = ref.split('#', 2);
        this._module = path[0] == '.' ? path_1.resolve(parentPath, path) : path;
        this._module = require.resolve(this._module);
        this._path = path_1.dirname(this._module);
        if (inner) {
            this._ref = require(this._module)[name || 'default'];
        }
        else {
            this._ref = require(this._module);
        }
    }
    get ref() { return this._ref; }
    get module() { return this._module; }
    get path() { return this._path; }
}
exports.ExportStringRef = ExportStringRef;
//# sourceMappingURL=data:application/json;base64,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