"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const options_1 = require("./options");
class TslintFixTask {
    constructor(configOrPath, options) {
        if (options) {
            this._configOrPath = configOrPath;
            this._options = options;
        }
        else {
            this._options = configOrPath;
            this._configOrPath = null;
        }
    }
    toConfiguration() {
        const path = typeof this._configOrPath == 'string' ? { tslintPath: this._configOrPath } : {};
        const config = typeof this._configOrPath == 'object' && this._configOrPath !== null
            ? { tslintConfig: this._configOrPath }
            : {};
        const options = Object.assign({}, this._options, path, config);
        return { name: options_1.TslintFixName, options };
    }
}
exports.TslintFixTask = TslintFixTask;
//# sourceMappingURL=data:application/json;base64,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