"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var MergeStrategy;
(function (MergeStrategy) {
    MergeStrategy[MergeStrategy["AllowOverwriteConflict"] = 2] = "AllowOverwriteConflict";
    MergeStrategy[MergeStrategy["AllowCreationConflict"] = 4] = "AllowCreationConflict";
    MergeStrategy[MergeStrategy["AllowDeleteConflict"] = 8] = "AllowDeleteConflict";
    // Uses the default strategy.
    MergeStrategy[MergeStrategy["Default"] = 0] = "Default";
    // Error out if 2 files have the same path. It is useful to have a different value than
    // Default in this case as the tooling Default might differ.
    MergeStrategy[MergeStrategy["Error"] = 1] = "Error";
    // Only content conflicts are overwritten.
    MergeStrategy[MergeStrategy["ContentOnly"] = 2] = "ContentOnly";
    // Overwrite everything with the latest change.
    MergeStrategy[MergeStrategy["Overwrite"] = 14] = "Overwrite";
})(MergeStrategy = exports.MergeStrategy || (exports.MergeStrategy = {}));
exports.FileVisitorCancelToken = Symbol();
exports.TreeSymbol = (function () {
    const globalSymbol = (typeof window == 'object' && window.window === window && window.Symbol)
        || (typeof self == 'object' && self.self === self && self.Symbol)
        || (typeof global == 'object' && global.global === global && global.Symbol);
    if (!globalSymbol) {
        return Symbol('schematic-tree');
    }
    if (!globalSymbol.schematicTree) {
        globalSymbol.schematicTree = Symbol('schematic-tree');
    }
    return globalSymbol.schematicTree;
})();
var Tree;
(function (Tree) {
    function isTree(maybeTree) {
        return exports.TreeSymbol in maybeTree;
    }
    Tree.isTree = isTree;
})(Tree || (Tree = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZXJmYWNlLmpzIiwic291cmNlUm9vdCI6Ii4vIiwic291cmNlcyI6WyJwYWNrYWdlcy9hbmd1bGFyX2RldmtpdC9zY2hlbWF0aWNzL3NyYy90cmVlL2ludGVyZmFjZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQVdBLElBQVksYUFtQlg7QUFuQkQsV0FBWSxhQUFhO0lBQ3ZCLHFGQUFrQyxDQUFBO0lBQ2xDLG1GQUFrQyxDQUFBO0lBQ2xDLCtFQUFrQyxDQUFBO0lBRWxDLDZCQUE2QjtJQUM3Qix1REFBNkIsQ0FBQTtJQUU3Qix1RkFBdUY7SUFDdkYsNERBQTREO0lBQzVELG1EQUFrQyxDQUFBO0lBRWxDLDBDQUEwQztJQUMxQywrREFBa0QsQ0FBQTtJQUVsRCwrQ0FBK0M7SUFDL0MsNERBRStDLENBQUE7QUFDakQsQ0FBQyxFQW5CVyxhQUFhLEdBQWIscUJBQWEsS0FBYixxQkFBYSxRQW1CeEI7QUFHWSxRQUFBLHNCQUFzQixHQUFXLE1BQU0sRUFBRSxDQUFDO0FBNkIxQyxRQUFBLFVBQVUsR0FBVyxDQUFDO0lBQ2pDLE1BQU0sWUFBWSxHQUFHLENBQUMsT0FBTyxNQUFNLElBQUksUUFBUSxJQUFJLE1BQU0sQ0FBQyxNQUFNLEtBQUssTUFBTSxJQUFJLE1BQU0sQ0FBQyxNQUFNLENBQUM7V0FDeEUsQ0FBQyxPQUFPLElBQUksSUFBSSxRQUFRLElBQUksSUFBSSxDQUFDLElBQUksS0FBSyxJQUFJLElBQUksSUFBSSxDQUFDLE1BQU0sQ0FBQztXQUM5RCxDQUFDLE9BQU8sTUFBTSxJQUFJLFFBQVEsSUFBSSxNQUFNLENBQUMsTUFBTSxLQUFLLE1BQU0sSUFBSSxNQUFNLENBQUMsTUFBTSxDQUFDLENBQUM7SUFFOUYsSUFBSSxDQUFDLFlBQVksRUFBRTtRQUNqQixPQUFPLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO0tBQ2pDO0lBRUQsSUFBSSxDQUFDLFlBQVksQ0FBQyxhQUFhLEVBQUU7UUFDL0IsWUFBWSxDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztLQUN2RDtJQUVELE9BQU8sWUFBWSxDQUFDLGFBQWEsQ0FBQztBQUNwQyxDQUFDLENBQUMsRUFBRSxDQUFDO0FBK0JMLElBQVUsSUFBSSxDQUliO0FBSkQsV0FBVSxJQUFJO0lBQ1osZ0JBQXVCLFNBQWlCO1FBQ3RDLE9BQU8sa0JBQVUsSUFBSSxTQUFTLENBQUM7SUFDakMsQ0FBQztJQUZlLFdBQU0sU0FFckIsQ0FBQTtBQUNILENBQUMsRUFKUyxJQUFJLEtBQUosSUFBSSxRQUliIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBAbGljZW5zZVxuICogQ29weXJpZ2h0IEdvb2dsZSBJbmMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogVXNlIG9mIHRoaXMgc291cmNlIGNvZGUgaXMgZ292ZXJuZWQgYnkgYW4gTUlULXN0eWxlIGxpY2Vuc2UgdGhhdCBjYW4gYmVcbiAqIGZvdW5kIGluIHRoZSBMSUNFTlNFIGZpbGUgYXQgaHR0cHM6Ly9hbmd1bGFyLmlvL2xpY2Vuc2VcbiAqL1xuaW1wb3J0IHsgUGF0aCwgUGF0aEZyYWdtZW50IH0gZnJvbSAnQGFuZ3VsYXItZGV2a2l0L2NvcmUnO1xuaW1wb3J0IHsgQWN0aW9uIH0gZnJvbSAnLi9hY3Rpb24nO1xuXG5cbmV4cG9ydCBlbnVtIE1lcmdlU3RyYXRlZ3kge1xuICBBbGxvd092ZXJ3cml0ZUNvbmZsaWN0ICAgID0gMSA8PCAxLFxuICBBbGxvd0NyZWF0aW9uQ29uZmxpY3QgICAgID0gMSA8PCAyLFxuICBBbGxvd0RlbGV0ZUNvbmZsaWN0ICAgICAgID0gMSA8PCAzLFxuXG4gIC8vIFVzZXMgdGhlIGRlZmF1bHQgc3RyYXRlZ3kuXG4gIERlZmF1bHQgICAgICAgICAgICAgICAgICAgPSAwLFxuXG4gIC8vIEVycm9yIG91dCBpZiAyIGZpbGVzIGhhdmUgdGhlIHNhbWUgcGF0aC4gSXQgaXMgdXNlZnVsIHRvIGhhdmUgYSBkaWZmZXJlbnQgdmFsdWUgdGhhblxuICAvLyBEZWZhdWx0IGluIHRoaXMgY2FzZSBhcyB0aGUgdG9vbGluZyBEZWZhdWx0IG1pZ2h0IGRpZmZlci5cbiAgRXJyb3IgICAgICAgICAgICAgICAgICAgICA9IDEgPDwgMCxcblxuICAvLyBPbmx5IGNvbnRlbnQgY29uZmxpY3RzIGFyZSBvdmVyd3JpdHRlbi5cbiAgQ29udGVudE9ubHkgICAgICAgICAgICAgICA9IEFsbG93T3ZlcndyaXRlQ29uZmxpY3QsXG5cbiAgLy8gT3ZlcndyaXRlIGV2ZXJ5dGhpbmcgd2l0aCB0aGUgbGF0ZXN0IGNoYW5nZS5cbiAgT3ZlcndyaXRlICAgICAgICAgICAgICAgICA9IEFsbG93T3ZlcndyaXRlQ29uZmxpY3RcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICArIEFsbG93Q3JlYXRpb25Db25mbGljdFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICsgQWxsb3dEZWxldGVDb25mbGljdCxcbn1cblxuXG5leHBvcnQgY29uc3QgRmlsZVZpc2l0b3JDYW5jZWxUb2tlbjogc3ltYm9sID0gU3ltYm9sKCk7XG5leHBvcnQgdHlwZSBGaWxlVmlzaXRvciA9IEZpbGVQcmVkaWNhdGU8dm9pZD47XG5cbmV4cG9ydCBpbnRlcmZhY2UgRmlsZUVudHJ5IHtcbiAgcmVhZG9ubHkgcGF0aDogUGF0aDtcbiAgcmVhZG9ubHkgY29udGVudDogQnVmZmVyO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIERpckVudHJ5IHtcbiAgcmVhZG9ubHkgcGFyZW50OiBEaXJFbnRyeSB8IG51bGw7XG4gIHJlYWRvbmx5IHBhdGg6IFBhdGg7XG5cbiAgcmVhZG9ubHkgc3ViZGlyczogUGF0aEZyYWdtZW50W107XG4gIHJlYWRvbmx5IHN1YmZpbGVzOiBQYXRoRnJhZ21lbnRbXTtcblxuICBkaXIobmFtZTogUGF0aEZyYWdtZW50KTogRGlyRW50cnk7XG4gIGZpbGUobmFtZTogUGF0aEZyYWdtZW50KTogRmlsZUVudHJ5IHwgbnVsbDtcblxuICB2aXNpdCh2aXNpdG9yOiBGaWxlVmlzaXRvcik6IHZvaWQ7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgRmlsZVByZWRpY2F0ZTxUPiB7XG4gIChwYXRoOiBQYXRoLCBlbnRyeT86IFJlYWRvbmx5PEZpbGVFbnRyeT4gfCBudWxsKTogVDtcbn1cblxuZGVjbGFyZSBjb25zdCB3aW5kb3c6IHsgU3ltYm9sOiB7IHNjaGVtYXRpY1RyZWU6IHN5bWJvbCB9LCB3aW5kb3c6IHt9IH07XG5kZWNsYXJlIGNvbnN0IHNlbGY6IHsgU3ltYm9sOiB7IHNjaGVtYXRpY1RyZWU6IHN5bWJvbCB9LCBzZWxmOiB7fSB9O1xuZGVjbGFyZSBjb25zdCBnbG9iYWw6IHsgU3ltYm9sOiB7IHNjaGVtYXRpY1RyZWU6IHN5bWJvbCB9LCBnbG9iYWw6IHt9IH07XG5cbmV4cG9ydCBjb25zdCBUcmVlU3ltYm9sOiBzeW1ib2wgPSAoZnVuY3Rpb24oKSB7XG4gIGNvbnN0IGdsb2JhbFN5bWJvbCA9ICh0eXBlb2Ygd2luZG93ID09ICdvYmplY3QnICYmIHdpbmRvdy53aW5kb3cgPT09IHdpbmRvdyAmJiB3aW5kb3cuU3ltYm9sKVxuICAgICAgICAgICAgICAgICAgICB8fCAodHlwZW9mIHNlbGYgPT0gJ29iamVjdCcgJiYgc2VsZi5zZWxmID09PSBzZWxmICYmIHNlbGYuU3ltYm9sKVxuICAgICAgICAgICAgICAgICAgICB8fCAodHlwZW9mIGdsb2JhbCA9PSAnb2JqZWN0JyAmJiBnbG9iYWwuZ2xvYmFsID09PSBnbG9iYWwgJiYgZ2xvYmFsLlN5bWJvbCk7XG5cbiAgaWYgKCFnbG9iYWxTeW1ib2wpIHtcbiAgICByZXR1cm4gU3ltYm9sKCdzY2hlbWF0aWMtdHJlZScpO1xuICB9XG5cbiAgaWYgKCFnbG9iYWxTeW1ib2wuc2NoZW1hdGljVHJlZSkge1xuICAgIGdsb2JhbFN5bWJvbC5zY2hlbWF0aWNUcmVlID0gU3ltYm9sKCdzY2hlbWF0aWMtdHJlZScpO1xuICB9XG5cbiAgcmV0dXJuIGdsb2JhbFN5bWJvbC5zY2hlbWF0aWNUcmVlO1xufSkoKTtcblxuXG5leHBvcnQgaW50ZXJmYWNlIFRyZWUge1xuICBicmFuY2goKTogVHJlZTtcbiAgbWVyZ2Uob3RoZXI6IFRyZWUsIHN0cmF0ZWd5PzogTWVyZ2VTdHJhdGVneSk6IHZvaWQ7XG5cbiAgcmVhZG9ubHkgcm9vdDogRGlyRW50cnk7XG5cbiAgLy8gUmVhZG9ubHkuXG4gIHJlYWQocGF0aDogc3RyaW5nKTogQnVmZmVyIHwgbnVsbDtcbiAgZXhpc3RzKHBhdGg6IHN0cmluZyk6IGJvb2xlYW47XG4gIGdldChwYXRoOiBzdHJpbmcpOiBGaWxlRW50cnkgfCBudWxsO1xuICBnZXREaXIocGF0aDogc3RyaW5nKTogRGlyRW50cnk7XG4gIHZpc2l0KHZpc2l0b3I6IEZpbGVWaXNpdG9yKTogdm9pZDtcblxuICAvLyBDaGFuZ2UgY29udGVudCBvZiBob3N0IGZpbGVzLlxuICBvdmVyd3JpdGUocGF0aDogc3RyaW5nLCBjb250ZW50OiBCdWZmZXIgfCBzdHJpbmcpOiB2b2lkO1xuICBiZWdpblVwZGF0ZShwYXRoOiBzdHJpbmcpOiBVcGRhdGVSZWNvcmRlcjtcbiAgY29tbWl0VXBkYXRlKHJlY29yZDogVXBkYXRlUmVjb3JkZXIpOiB2b2lkO1xuXG4gIC8vIFN0cnVjdHVyYWwgbWV0aG9kcy5cbiAgY3JlYXRlKHBhdGg6IHN0cmluZywgY29udGVudDogQnVmZmVyIHwgc3RyaW5nKTogdm9pZDtcbiAgZGVsZXRlKHBhdGg6IHN0cmluZyk6IHZvaWQ7XG4gIHJlbmFtZShmcm9tOiBzdHJpbmcsIHRvOiBzdHJpbmcpOiB2b2lkO1xuXG4gIGFwcGx5KGFjdGlvbjogQWN0aW9uLCBzdHJhdGVneT86IE1lcmdlU3RyYXRlZ3kpOiB2b2lkO1xuICByZWFkb25seSBhY3Rpb25zOiBBY3Rpb25bXTtcbn1cblxuXG5uYW1lc3BhY2UgVHJlZSB7XG4gIGV4cG9ydCBmdW5jdGlvbiBpc1RyZWUobWF5YmVUcmVlOiBvYmplY3QpOiBtYXliZVRyZWUgaXMgVHJlZSB7XG4gICAgcmV0dXJuIFRyZWVTeW1ib2wgaW4gbWF5YmVUcmVlO1xuICB9XG59XG5cblxuZXhwb3J0IGludGVyZmFjZSBVcGRhdGVSZWNvcmRlciB7XG4gIC8vIFRoZXNlIGp1c3QgcmVjb3JkIGNoYW5nZXMuXG4gIGluc2VydExlZnQoaW5kZXg6IG51bWJlciwgY29udGVudDogQnVmZmVyIHwgc3RyaW5nKTogVXBkYXRlUmVjb3JkZXI7XG4gIGluc2VydFJpZ2h0KGluZGV4OiBudW1iZXIsIGNvbnRlbnQ6IEJ1ZmZlciB8IHN0cmluZyk6IFVwZGF0ZVJlY29yZGVyO1xuICByZW1vdmUoaW5kZXg6IG51bWJlciwgbGVuZ3RoOiBudW1iZXIpOiBVcGRhdGVSZWNvcmRlcjtcbn1cbiJdfQ==