"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const interface_1 = require("./interface");
class DelegateTree {
    constructor(_other) {
        this._other = _other;
    }
    branch() { return this._other.branch(); }
    merge(other, strategy) { this._other.merge(other, strategy); }
    get root() { return this._other.root; }
    // Readonly.
    read(path) { return this._other.read(path); }
    exists(path) { return this._other.exists(path); }
    get(path) { return this._other.get(path); }
    getDir(path) { return this._other.getDir(path); }
    visit(visitor) { return this._other.visit(visitor); }
    // Change content of host files.
    overwrite(path, content) {
        return this._other.overwrite(path, content);
    }
    beginUpdate(path) { return this._other.beginUpdate(path); }
    commitUpdate(record) { return this._other.commitUpdate(record); }
    // Structural methods.
    create(path, content) {
        return this._other.create(path, content);
    }
    delete(path) { return this._other.delete(path); }
    rename(from, to) { return this._other.rename(from, to); }
    apply(action, strategy) {
        return this._other.apply(action, strategy);
    }
    get actions() { return this._other.actions; }
    [interface_1.TreeSymbol]() {
        return this;
    }
}
exports.DelegateTree = DelegateTree;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGVsZWdhdGUuanMiLCJzb3VyY2VSb290IjoiLi8iLCJzb3VyY2VzIjpbInBhY2thZ2VzL2FuZ3VsYXJfZGV2a2l0L3NjaGVtYXRpY3Mvc3JjL3RyZWUvZGVsZWdhdGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFRQSwyQ0FRcUI7QUFFckI7SUFDRSxZQUFzQixNQUFZO1FBQVosV0FBTSxHQUFOLE1BQU0sQ0FBTTtJQUFHLENBQUM7SUFFdEMsTUFBTSxLQUFXLE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQyxNQUFNLEVBQUUsQ0FBQyxDQUFDLENBQUM7SUFDL0MsS0FBSyxDQUFDLEtBQVcsRUFBRSxRQUF3QixJQUFVLElBQUksQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDLEtBQUssRUFBRSxRQUFRLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFFMUYsSUFBSSxJQUFJLEtBQWUsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFFakQsWUFBWTtJQUNaLElBQUksQ0FBQyxJQUFZLElBQW1CLE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ3BFLE1BQU0sQ0FBQyxJQUFZLElBQWEsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDbEUsR0FBRyxDQUFDLElBQVksSUFBc0IsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDckUsTUFBTSxDQUFDLElBQVksSUFBYyxPQUFPLElBQUksQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUNuRSxLQUFLLENBQUMsT0FBb0IsSUFBVSxPQUFPLElBQUksQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUV4RSxnQ0FBZ0M7SUFDaEMsU0FBUyxDQUFDLElBQVksRUFBRSxPQUF3QjtRQUM5QyxPQUFPLElBQUksQ0FBQyxNQUFNLENBQUMsU0FBUyxDQUFDLElBQUksRUFBRSxPQUFPLENBQUMsQ0FBQztJQUM5QyxDQUFDO0lBQ0QsV0FBVyxDQUFDLElBQVksSUFBb0IsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDbkYsWUFBWSxDQUFDLE1BQXNCLElBQVUsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFFdkYsc0JBQXNCO0lBQ3RCLE1BQU0sQ0FBQyxJQUFZLEVBQUUsT0FBd0I7UUFDM0MsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEVBQUUsT0FBTyxDQUFDLENBQUM7SUFDM0MsQ0FBQztJQUNELE1BQU0sQ0FBQyxJQUFZLElBQVUsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDL0QsTUFBTSxDQUFDLElBQVksRUFBRSxFQUFVLElBQVUsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBRS9FLEtBQUssQ0FBQyxNQUFjLEVBQUUsUUFBd0I7UUFDNUMsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxNQUFNLEVBQUUsUUFBUSxDQUFDLENBQUM7SUFDN0MsQ0FBQztJQUNELElBQUksT0FBTyxLQUFlLE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBRXZELENBQUMsc0JBQVUsQ0FBQztRQUNWLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztDQUNGO0FBckNELG9DQXFDQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQGxpY2Vuc2VcbiAqIENvcHlyaWdodCBHb29nbGUgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqIFVzZSBvZiB0aGlzIHNvdXJjZSBjb2RlIGlzIGdvdmVybmVkIGJ5IGFuIE1JVC1zdHlsZSBsaWNlbnNlIHRoYXQgY2FuIGJlXG4gKiBmb3VuZCBpbiB0aGUgTElDRU5TRSBmaWxlIGF0IGh0dHBzOi8vYW5ndWxhci5pby9saWNlbnNlXG4gKi9cbmltcG9ydCB7IEFjdGlvbiB9IGZyb20gJy4vYWN0aW9uJztcbmltcG9ydCB7XG4gIERpckVudHJ5LFxuICBGaWxlRW50cnksXG4gIEZpbGVWaXNpdG9yLFxuICBNZXJnZVN0cmF0ZWd5LFxuICBUcmVlLFxuICBUcmVlU3ltYm9sLFxuICBVcGRhdGVSZWNvcmRlcixcbn0gZnJvbSAnLi9pbnRlcmZhY2UnO1xuXG5leHBvcnQgY2xhc3MgRGVsZWdhdGVUcmVlIGltcGxlbWVudHMgVHJlZSB7XG4gIGNvbnN0cnVjdG9yKHByb3RlY3RlZCBfb3RoZXI6IFRyZWUpIHt9XG5cbiAgYnJhbmNoKCk6IFRyZWUgeyByZXR1cm4gdGhpcy5fb3RoZXIuYnJhbmNoKCk7IH1cbiAgbWVyZ2Uob3RoZXI6IFRyZWUsIHN0cmF0ZWd5PzogTWVyZ2VTdHJhdGVneSk6IHZvaWQgeyB0aGlzLl9vdGhlci5tZXJnZShvdGhlciwgc3RyYXRlZ3kpOyB9XG5cbiAgZ2V0IHJvb3QoKTogRGlyRW50cnkgeyByZXR1cm4gdGhpcy5fb3RoZXIucm9vdDsgfVxuXG4gIC8vIFJlYWRvbmx5LlxuICByZWFkKHBhdGg6IHN0cmluZyk6IEJ1ZmZlciB8IG51bGwgeyByZXR1cm4gdGhpcy5fb3RoZXIucmVhZChwYXRoKTsgfVxuICBleGlzdHMocGF0aDogc3RyaW5nKTogYm9vbGVhbiB7IHJldHVybiB0aGlzLl9vdGhlci5leGlzdHMocGF0aCk7IH1cbiAgZ2V0KHBhdGg6IHN0cmluZyk6IEZpbGVFbnRyeSB8IG51bGwgeyByZXR1cm4gdGhpcy5fb3RoZXIuZ2V0KHBhdGgpOyB9XG4gIGdldERpcihwYXRoOiBzdHJpbmcpOiBEaXJFbnRyeSB7IHJldHVybiB0aGlzLl9vdGhlci5nZXREaXIocGF0aCk7IH1cbiAgdmlzaXQodmlzaXRvcjogRmlsZVZpc2l0b3IpOiB2b2lkIHsgcmV0dXJuIHRoaXMuX290aGVyLnZpc2l0KHZpc2l0b3IpOyB9XG5cbiAgLy8gQ2hhbmdlIGNvbnRlbnQgb2YgaG9zdCBmaWxlcy5cbiAgb3ZlcndyaXRlKHBhdGg6IHN0cmluZywgY29udGVudDogQnVmZmVyIHwgc3RyaW5nKTogdm9pZCB7XG4gICAgcmV0dXJuIHRoaXMuX290aGVyLm92ZXJ3cml0ZShwYXRoLCBjb250ZW50KTtcbiAgfVxuICBiZWdpblVwZGF0ZShwYXRoOiBzdHJpbmcpOiBVcGRhdGVSZWNvcmRlciB7IHJldHVybiB0aGlzLl9vdGhlci5iZWdpblVwZGF0ZShwYXRoKTsgfVxuICBjb21taXRVcGRhdGUocmVjb3JkOiBVcGRhdGVSZWNvcmRlcik6IHZvaWQgeyByZXR1cm4gdGhpcy5fb3RoZXIuY29tbWl0VXBkYXRlKHJlY29yZCk7IH1cblxuICAvLyBTdHJ1Y3R1cmFsIG1ldGhvZHMuXG4gIGNyZWF0ZShwYXRoOiBzdHJpbmcsIGNvbnRlbnQ6IEJ1ZmZlciB8IHN0cmluZyk6IHZvaWQge1xuICAgIHJldHVybiB0aGlzLl9vdGhlci5jcmVhdGUocGF0aCwgY29udGVudCk7XG4gIH1cbiAgZGVsZXRlKHBhdGg6IHN0cmluZyk6IHZvaWQgeyByZXR1cm4gdGhpcy5fb3RoZXIuZGVsZXRlKHBhdGgpOyB9XG4gIHJlbmFtZShmcm9tOiBzdHJpbmcsIHRvOiBzdHJpbmcpOiB2b2lkIHsgcmV0dXJuIHRoaXMuX290aGVyLnJlbmFtZShmcm9tLCB0byk7IH1cblxuICBhcHBseShhY3Rpb246IEFjdGlvbiwgc3RyYXRlZ3k/OiBNZXJnZVN0cmF0ZWd5KTogdm9pZCB7XG4gICAgcmV0dXJuIHRoaXMuX290aGVyLmFwcGx5KGFjdGlvbiwgc3RyYXRlZ3kpO1xuICB9XG4gIGdldCBhY3Rpb25zKCk6IEFjdGlvbltdIHsgcmV0dXJuIHRoaXMuX290aGVyLmFjdGlvbnM7IH1cblxuICBbVHJlZVN5bWJvbF0oKSB7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cbn1cbiJdfQ==