"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const rxjs_1 = require("rxjs");
const operators_1 = require("rxjs/operators");
const update_buffer_1 = require("../utility/update-buffer");
const sink_1 = require("./sink");
class HostSink extends sink_1.SimpleSinkBase {
    constructor(_host, _force = false) {
        super();
        this._host = _host;
        this._force = _force;
        this._filesToDelete = new Set();
        this._filesToRename = new Set();
        this._filesToCreate = new Map();
        this._filesToUpdate = new Map();
    }
    _validateCreateAction(action) {
        return this._force ? rxjs_1.EMPTY : super._validateCreateAction(action);
    }
    _validateFileExists(p) {
        if (this._filesToCreate.has(p) || this._filesToUpdate.has(p)) {
            return rxjs_1.of(true);
        }
        else if (this._filesToDelete.has(p)) {
            return rxjs_1.of(false);
        }
        else if ([...this._filesToRename.values()].some(([from]) => from == p)) {
            return rxjs_1.of(false);
        }
        else {
            return this._host.exists(p);
        }
    }
    _overwriteFile(path, content) {
        this._filesToUpdate.set(path, new update_buffer_1.UpdateBuffer(content));
        return rxjs_1.EMPTY;
    }
    _createFile(path, content) {
        this._filesToCreate.set(path, new update_buffer_1.UpdateBuffer(content));
        return rxjs_1.EMPTY;
    }
    _renameFile(from, to) {
        this._filesToRename.add([from, to]);
        return rxjs_1.EMPTY;
    }
    _deleteFile(path) {
        if (this._filesToCreate.has(path)) {
            this._filesToCreate.delete(path);
            this._filesToUpdate.delete(path);
        }
        else {
            this._filesToDelete.add(path);
        }
        return rxjs_1.EMPTY;
    }
    _done() {
        // Really commit everything to the actual filesystem.
        return rxjs_1.concat(rxjs_1.from([...this._filesToDelete.values()]).pipe(operators_1.concatMap(path => this._host.delete(path))), rxjs_1.from([...this._filesToRename.entries()]).pipe(operators_1.concatMap(([_, [path, to]]) => this._host.rename(path, to))), rxjs_1.from([...this._filesToCreate.entries()]).pipe(operators_1.concatMap(([path, buffer]) => {
            return this._host.write(path, buffer.generate());
        })), rxjs_1.from([...this._filesToUpdate.entries()]).pipe(operators_1.concatMap(([path, buffer]) => {
            return this._host.write(path, buffer.generate());
        }))).pipe(operators_1.reduce(() => { }));
    }
}
exports.HostSink = HostSink;
//# sourceMappingURL=data:application/json;base64,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