"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const utils_1 = require("../models/webpack-configs/utils");
function generateEntryPoints(appConfig) {
    const entryPoints = ['polyfills', 'sw-register'];
    // Add all styles/scripts, except lazy-loaded ones.
    [
        ...utils_1.normalizeExtraEntryPoints(appConfig.styles, 'styles')
            .filter(entry => !entry.lazy)
            .map(entry => entry.bundleName),
        ...utils_1.normalizeExtraEntryPoints(appConfig.scripts, 'scripts')
            .filter(entry => !entry.lazy)
            .map(entry => entry.bundleName),
    ].forEach(bundleName => {
        if (entryPoints.indexOf(bundleName) === -1) {
            entryPoints.push(bundleName);
        }
    });
    entryPoints.push('main');
    return entryPoints;
}
exports.generateEntryPoints = generateEntryPoints;
//# sourceMappingURL=data:application/json;base64,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