"use strict";
// tslint:disable
// TODO: cleanup this file, it's copied as is from Angular CLI.
Object.defineProperty(exports, "__esModule", { value: true });
const webpack_sources_1 = require("webpack-sources");
const CleanCSS = require('clean-css');
function hook(compiler, action) {
    if (compiler.hooks) {
        // Webpack 4
        compiler.hooks.compilation.tap('cleancss-webpack-plugin', (compilation) => {
            compilation.hooks.optimizeChunkAssets.tapPromise('cleancss-webpack-plugin', (chunks) => action(compilation, chunks));
        });
    }
    else {
        // Webpack 3
        compiler.plugin('compilation', (compilation) => {
            compilation.plugin('optimize-chunk-assets', (chunks, callback) => action(compilation, chunks)
                .then(() => callback())
                .catch((err) => callback(err)));
        });
    }
}
class CleanCssWebpackPlugin {
    constructor(options) {
        this._options = Object.assign({ sourceMap: false, test: (file) => file.endsWith('.css') }, options);
    }
    apply(compiler) {
        hook(compiler, (compilation, chunks) => {
            const cleancss = new CleanCSS({
                compatibility: 'ie9',
                level: {
                    2: {
                        skipProperties: ['transition'] // Fixes #12408
                    }
                },
                inline: false,
                returnPromise: true,
                sourceMap: this._options.sourceMap,
            });
            const files = [...compilation.additionalChunkAssets];
            chunks.forEach(chunk => {
                if (chunk.files && chunk.files.length > 0) {
                    files.push(...chunk.files);
                }
            });
            const actions = files
                .filter(file => this._options.test(file))
                .map(file => {
                const asset = compilation.assets[file];
                if (!asset) {
                    return Promise.resolve();
                }
                let content;
                let map;
                if (this._options.sourceMap && asset.sourceAndMap) {
                    const sourceAndMap = asset.sourceAndMap();
                    content = sourceAndMap.source;
                    map = sourceAndMap.map;
                }
                else {
                    content = asset.source();
                }
                if (content.length === 0) {
                    return Promise.resolve();
                }
                return Promise.resolve()
                    .then(() => map ? cleancss.minify(content, map) : cleancss.minify(content))
                    .then((output) => {
                    let hasWarnings = false;
                    if (output.warnings && output.warnings.length > 0) {
                        compilation.warnings.push(...output.warnings);
                        hasWarnings = true;
                    }
                    if (output.errors && output.errors.length > 0) {
                        output.errors
                            .forEach((error) => compilation.errors.push(new Error(error)));
                        return;
                    }
                    // generally means invalid syntax so bail
                    if (hasWarnings && output.stats.minifiedSize === 0) {
                        return;
                    }
                    let newSource;
                    if (output.sourceMap) {
                        newSource = new webpack_sources_1.SourceMapSource(output.styles, file, output.sourceMap.toString(), content, map);
                    }
                    else {
                        newSource = new webpack_sources_1.RawSource(output.styles);
                    }
                    compilation.assets[file] = newSource;
                });
            });
            return Promise.all(actions);
        });
    }
}
exports.CleanCssWebpackPlugin = CleanCssWebpackPlugin;
//# sourceMappingURL=data:application/json;base64,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