"use strict";
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
const webpackOutputOptions = {
    colors: true,
    hash: true,
    timings: true,
    chunks: true,
    chunkModules: false,
    children: false,
    modules: false,
    reasons: false,
    warnings: true,
    errors: true,
    assets: true,
    version: false,
    errorDetails: false,
    moduleTrace: false,
};
const verboseWebpackOutputOptions = {
    children: true,
    assets: true,
    version: true,
    reasons: true,
    chunkModules: false,
    errorDetails: true,
    moduleTrace: true,
};
function getWebpackStatsConfig(verbose = false) {
    return verbose
        ? Object.assign(webpackOutputOptions, verboseWebpackOutputOptions)
        : webpackOutputOptions;
}
exports.getWebpackStatsConfig = getWebpackStatsConfig;
function getStatsConfig(wco) {
    const verbose = !!wco.buildOptions.verbose;
    return { stats: getWebpackStatsConfig(verbose) };
}
exports.getStatsConfig = getStatsConfig;
//# sourceMappingURL=data:application/json;base64,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