# Deployment process

* install php dependencies 
```
> cd [project-root]
> composer install
```
* Install angular deps

```
> cd [project-root]/resource/angular-app
> npm install

```
* Copy the env.example to .env at the project root
* Update .env file for the settings you want
* Create database and update the value in the .env file
* Run `php artisan migrate` from project root
* Run `php artisan db seed` from project root
* Run `php artisan passport:install` from project root
* Copy the Password client `id` and `token`  and paste set the value of AUTH_CLIENT_ID and AUTH_CLIENT_SECRET respectively
* Copy `[project-root]/resource/angular-app/src/environments/environment.prod.ts` to `[project-root]/resources/angular-app/src/environments/environment.ts`
* Run `php artisan nicoAngularAppDeploy --advanced --build-option=prod` from the project root
* you app should be up and running.
