(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["pages-publishers-publishers-module"],{

/***/ "./src/app/admin-module/pages/publishers/components/AbstractPublisherCreateComponent.ts":
/*!**********************************************************************************************!*\
  !*** ./src/app/admin-module/pages/publishers/components/AbstractPublisherCreateComponent.ts ***!
  \**********************************************************************************************/
/*! exports provided: AbstractPublisherCreateComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AbstractPublisherCreateComponent", function() { return AbstractPublisherCreateComponent; });
/* harmony import */ var _services_publisher_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../services/publisher.service */ "./src/app/admin-module/pages/publishers/services/publisher.service.ts");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/forms */ "./node_modules/@angular/forms/fesm5/forms.js");
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! rxjs */ "./node_modules/rxjs/_esm5/index.js");
/* harmony import */ var _system_components_modal_AbstractNicoModalComponent__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../system/components/modal/AbstractNicoModalComponent */ "./src/app/system/components/modal/AbstractNicoModalComponent.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();




var AbstractPublisherCreateComponent = /** @class */ (function (_super) {
    __extends(AbstractPublisherCreateComponent, _super);
    /**
     * constrcutor
     * @param injector
     */
    function AbstractPublisherCreateComponent(injector) {
        var _this = _super.call(this, injector) || this;
        _this.thumbUploadOptions = null;
        _this.busySaving = false;
        /**
       * Form id
       */
        _this.formId = 'edit-form';
        _this.service = injector.get(_services_publisher_service__WEBPACK_IMPORTED_MODULE_0__["PublisherService"]);
        return _this;
    }
    AbstractPublisherCreateComponent.prototype.onFileUploadComplete = function (event, formControlName) {
        this.formGroup.controls[formControlName].setValue(event.body.path);
    };
    AbstractPublisherCreateComponent.prototype.setUploadOption = function () {
        this.thumbUploadOptions = {
            title: 'Logo',
            instantUpload: true,
            cancellable: false,
            disabledOnComplete: true,
            hidden: false,
            uploadInputConfig: {
                type: 'uploadAll',
                url: this.service.getBaseApiUrl() + '/upload-resources',
                headers: { 'Authorization': 'Bearer ' + this.session.getToken() },
                method: 'POST',
                fieldName: 'file',
                data: { 'type': 'image' },
            }
        };
    };
    /**
     * Lifecycle event
     */
    AbstractPublisherCreateComponent.prototype.ngOnInit = function () {
        _super.prototype.ngOnInit.call(this);
        this.setUploadOption();
        this.formGroup = this.formBuilder.group({
            title: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].compose([_angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required])],
            street: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].compose([_angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required])],
            city: [''],
            phone_number: [''],
            fax_number: [''],
            email: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].compose([_angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required])],
            logo_url: [''],
        });
        if (this.data.model) {
            this.formGroup.patchValue(this.data.model);
        }
    };
    /**
     * Save the form data
     */
    AbstractPublisherCreateComponent.prototype.saveForm = function () {
        var _this = this;
        if (this.busySaving) {
            return;
        }
        var spinner = this.ajaxSpinner.showSpinner();
        this.busySaving = true;
        var observable = new rxjs__WEBPACK_IMPORTED_MODULE_2__["Subject"]();
        this.service.save(this.formGroup.value, this.data.model ? this.data.model.id : null).subscribe(function () {
            spinner.hide();
            _this.busySaving = false;
            return observable.next();
        }, function (response) {
            spinner.hide();
            _this.busySaving = false;
            if (!response.status.messageShown) {
                _this.showErrorToast(response.status.message);
            }
            if (response.status.statusCode === 417) {
                _this.validationMessenger.attach(_this.formId, response.body);
            }
            return observable.error(response);
        });
        return observable;
    };
    /**
     * Cancel form
     */
    AbstractPublisherCreateComponent.prototype.cancelForm = function () {
        this.dismisser();
    };
    return AbstractPublisherCreateComponent;
}(_system_components_modal_AbstractNicoModalComponent__WEBPACK_IMPORTED_MODULE_3__["AbstractNicoModalComponent"]));



/***/ }),

/***/ "./src/app/admin-module/pages/publishers/components/add-publisher/add-publisher.component.html":
/*!*****************************************************************************************************!*\
  !*** ./src/app/admin-module/pages/publishers/components/add-publisher/add-publisher.component.html ***!
  \*****************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div class=\"modal-header\">\n  <h4 class=\"modal-title\">\n    <span class=\"modal-title-icon\">\n      <i class=\"fas fa-globe\"></i>\n    </span>\n    {{ modalTitle | translate}}\n  </h4>\n  <button class=\"custom-icon-button\" type=\"button\" aria-label=\"Close\" (click)=\"cancel()\">\n    <i class=\"fas fa-times\"></i>\n  </button>\n</div>\n<section class=\"modal-body\">\n  <form [id]=\"formId\" [formGroup]=\"formGroup\">\n    <div class=\"form-group\">\n      <label [for]=\"'deposit_slip_url'\">Logo</label>\n      <cmp-upload-file\n        [uploadOptions]=\"thumbUploadOptions\"\n        (complete)=\"onFileUploadComplete($event, 'logo_url')\"\n      ></cmp-upload-file>\n    </div>\n    <div class=\"form-group has-label\">\n      <label for=\"title\"\n             class=\"form-control-label\">{{'mod_manage.mod_publishers.title_label'|translate}}</label>\n      <input id=\"title\" type=\"text\" formControlName=\"title\" autocomplete=\"off\"\n             [placeholder]=\"'mod_manage.mod_publishers.title_placeholder_label'|translate\"\n             class=\"form-control\">\n    </div>\n    <div class=\"form-group has-label\">\n      <label for=\"street\"\n             class=\"form-control-label\">{{'mod_manage.mod_publishers.street_label'|translate}}</label>\n      <input id=\"street\" type=\"text\" formControlName=\"street\" autocomplete=\"off\"\n             [placeholder]=\"'mod_manage.mod_publishers.street_placeholder_label'|translate\"\n             class=\"form-control\">\n    </div>\n    <div class=\"form-group has-label\">\n      <label for=\"city\"\n             class=\"form-control-label\">{{'mod_manage.mod_publishers.city_label'|translate}}</label>\n      <input id=\"city\" type=\"text\" formControlName=\"city\" autocomplete=\"off\"\n             [placeholder]=\"'mod_manage.mod_publishers.city_placeholder_label'|translate\"\n             class=\"form-control\">\n    </div>\n    <div class=\"form-group has-label\">\n      <label for=\"city\"\n             class=\"form-control-label\">{{'mod_manage.mod_publishers.phone_number_label'|translate}}</label>\n      <input id=\"phone_number\" type=\"text\" formControlName=\"phone_number\" autocomplete=\"off\"\n             [placeholder]=\"'mod_manage.mod_publishers.phone_number_placeholder_label'|translate\"\n             class=\"form-control\">\n    </div>\n   <!-- <div class=\"form-group has-label\">\n      <label for=\"city\"\n             class=\"form-control-label\">{{'mod_manage.mod_publishers.fax_number_label'|translate}}</label>\n      <input id=\"fax_number\" type=\"text\" formControlName=\"fax_number\" autocomplete=\"off\"\n             [placeholder]=\"'mod_manage.mod_publishers.fax_number_placeholder_label'|translate\"\n             class=\"form-control\">\n    </div> -->\n\n    <div class=\"form-group has-label\">\n      <label for=\"city\"\n             class=\"form-control-label\">{{'mod_manage.mod_publishers.email_label'|translate}}</label>\n      <input id=\"email\" type=\"text\" formControlName=\"email\" autocomplete=\"off\"\n             [placeholder]=\"'mod_manage.mod_publishers.email_placeholder_label'|translate\"\n             class=\"form-control\">\n    </div>\n  </form>\n\n</section>\n<div class=\"modal-footer\">\n  <button class=\"btn btn-light mr-3\" (click)=\"cancel()\"\n          tabindex=\"2\">{{'mod_commons.cancel_label'|translate}}</button>\n  <button class=\"btn btn-primary\" (click)=\"save()\" tabindex=\"1\"\n          [disabled]=\"!formGroup.valid\">{{'mod_commons.save_label'|translate}}</button>\n</div>\n"

/***/ }),

/***/ "./src/app/admin-module/pages/publishers/components/add-publisher/add-publisher.component.ts":
/*!***************************************************************************************************!*\
  !*** ./src/app/admin-module/pages/publishers/components/add-publisher/add-publisher.component.ts ***!
  \***************************************************************************************************/
/*! exports provided: AddPublisherComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AddPublisherComponent", function() { return AddPublisherComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _AbstractPublisherCreateComponent__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../AbstractPublisherCreateComponent */ "./src/app/admin-module/pages/publishers/components/AbstractPublisherCreateComponent.ts");
/* harmony import */ var src_app_system_components_modal_NicoModalController__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! src/app/system/components/modal/NicoModalController */ "./src/app/system/components/modal/NicoModalController.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};



var AddPublisherComponent = /** @class */ (function (_super) {
    __extends(AddPublisherComponent, _super);
    /**
     * Constructor
     * @param injector
     * @param modalController
     */
    function AddPublisherComponent(injector, modalController) {
        var _this = _super.call(this, injector) || this;
        _this.modalController = modalController;
        /**
         * The id for video add form
         * @var string
         */
        _this.formId = "add-publisher-form";
        return _this;
    }
    /**
     *  Oninit lifecycle hook
     */
    AddPublisherComponent.prototype.ngOnInit = function () {
        _super.prototype.ngOnInit.call(this);
        this.setPageTitle('mod_manage.mod_publishers.add_page_title');
        this.modalTitle = 'mod_manage.mod_publishers.add_page_title';
        if (this.data.model) {
            this.setPageTitle("mod_manage.mod_publishers.edit_page_title", this.data.model.title);
            this.modalTitle = "Edit: " + this.data.model.title;
        }
    };
    /**
     * On form submit
     */
    AddPublisherComponent.prototype.save = function () {
        var _this = this;
        this.saveForm().subscribe(function () {
            _this.showSuccessToast('mod_manage.mod_publishers.add_success_message');
            _this.okayCompleteListener();
            _this.dismisser();
        });
    };
    /**
     * On cancle
     */
    AddPublisherComponent.prototype.cancel = function () {
        this.formGroup.reset();
        this.cancelForm();
    };
    AddPublisherComponent = __decorate([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_0__["Component"])({
            selector: 'app-create-publisher',
            template: __webpack_require__(/*! ./add-publisher.component.html */ "./src/app/admin-module/pages/publishers/components/add-publisher/add-publisher.component.html"),
            styleUrls: []
        }),
        __metadata("design:paramtypes", [_angular_core__WEBPACK_IMPORTED_MODULE_0__["Injector"], src_app_system_components_modal_NicoModalController__WEBPACK_IMPORTED_MODULE_2__["NicoModalController"]])
    ], AddPublisherComponent);
    return AddPublisherComponent;
}(_AbstractPublisherCreateComponent__WEBPACK_IMPORTED_MODULE_1__["AbstractPublisherCreateComponent"]));



/***/ }),

/***/ "./src/app/admin-module/pages/publishers/components/assign-publisher-owner/assign-publisher-owner.component.html":
/*!***********************************************************************************************************************!*\
  !*** ./src/app/admin-module/pages/publishers/components/assign-publisher-owner/assign-publisher-owner.component.html ***!
  \***********************************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<ng-template #publisherSelectItemTemplate let-item=\"item\">\n  <div class=\"adv-selected-option hand-cursor\" >\n    <div class=\"user-details\">\n      <span class=\"user-name\">{{item?.title}}</span>\n      <small class=\"user-email\">{{item?.email}}</small>\n    </div>\n  </div>\n</ng-template>\n<div class=\"modal-header\">\n  <h4 class=\"modal-title\">\n    <span class=\"modal-title-icon\">\n      <i class=\"fas fa-globe\"></i>\n    </span>\n    {{ modalTitle | translate}}\n  </h4>\n</div>\n<section class=\"modal-body\">\n  <form [id]=\"formId\" [formGroup]=\"formGroup\">\n    <div class=\"form-group\">\n      <label [for]=\"'publisher'\">Select the Publisher you want to be owner</label>\n      <div class=\"col-md-4\">\n        <advanced-select id=\"publisher_id\" formControlName=\"publisher\" [url]=\"publisherFetchUrl\" [config]=\"config\"  [(ngModel)]=\"publisherModel\" (ngModelChange)=\"onPublisherChange ()\"></advanced-select>\n      </div>\n    </div>\n    <div class=\"row\">\n      <div class=\"col-md-5\">\n    <div class=\"form-group has-label\">\n      <label [for]=\"'logo_url'\">Application Letter</label>\n      <cmp-upload-file\n      [uploadOptions]=\"letterUploadOptions\"\n      (complete)=\"onFileUploadComplete($event, 'application_letter')\"\n      ></cmp-upload-file>\n      <a class=\"small\" *ngIf=\"formGroup.value.application_letter\" (click)=\"viewImage(formGroup.value.application_letter, 'Application Letter')\">View current</a>\n    </div>\n  </div>\n  </div>\n  </form>\n\n</section>\n<div class=\"modal-footer\">\n  <button class=\"btn btn-light mr-3\" (click)=\"cancel()\"\n          tabindex=\"2\">{{'mod_commons.cancel_label'|translate}}</button>\n  <button class=\"btn btn-primary\" (click)=\"save()\" tabindex=\"1\"\n          [disabled]=\"!formGroup.valid\">{{'mod_commons.save_label'|translate}}</button>\n</div>\n"

/***/ }),

/***/ "./src/app/admin-module/pages/publishers/components/assign-publisher-owner/assign-publisher-owner.component.ts":
/*!*********************************************************************************************************************!*\
  !*** ./src/app/admin-module/pages/publishers/components/assign-publisher-owner/assign-publisher-owner.component.ts ***!
  \*********************************************************************************************************************/
/*! exports provided: AssignPublisherOwnerComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AssignPublisherOwnerComponent", function() { return AssignPublisherOwnerComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var src_app_system_components_modal_NicoModalController__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! src/app/system/components/modal/NicoModalController */ "./src/app/system/components/modal/NicoModalController.ts");
/* harmony import */ var _system_components_modal_AbstractNicoModalComponent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../../system/components/modal/AbstractNicoModalComponent */ "./src/app/system/components/modal/AbstractNicoModalComponent.ts");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/forms */ "./node_modules/@angular/forms/fesm5/forms.js");
/* harmony import */ var _services_publisher_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../services/publisher.service */ "./src/app/admin-module/pages/publishers/services/publisher.service.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};





var AssignPublisherOwnerComponent = /** @class */ (function (_super) {
    __extends(AssignPublisherOwnerComponent, _super);
    /**
     * Constructor
     * @param injector
     * @param modalController
     */
    function AssignPublisherOwnerComponent(injector, modalController) {
        var _this = _super.call(this, injector) || this;
        _this.modalController = modalController;
        /**
         * The id for video add form
         * @var string
         */
        _this.busySaving = false;
        _this.formId = "assign-publisher-owner-form";
        _this.modalTitle = "Assign Publiser Owner";
        _this.isbnAddOn = null;
        _this.publisherFetchUrl = "";
        _this.config = {};
        _this.service = injector.get(_services_publisher_service__WEBPACK_IMPORTED_MODULE_4__["PublisherService"]);
        return _this;
    }
    AssignPublisherOwnerComponent.prototype.setUploadOptions = function () {
        this.letterUploadOptions = {
            title: 'Application Letter',
            instantUpload: true,
            cancellable: false,
            disabledOnComplete: true,
            inputId: 'application_letter',
            hidden: false,
            uploadInputConfig: {
                type: 'uploadAll',
                url: this.service.getBaseApiUrl() + '/upload-resources',
                headers: { 'Authorization': 'Bearer ' + this.session.getToken() },
                method: 'POST',
                fieldName: 'file',
                data: { 'type': 'image_doc' },
            }
        };
    };
    AssignPublisherOwnerComponent.prototype.ngOnInit = function () {
        _super.prototype.ngOnInit.call(this);
        // this.setPageTitle('mod_manage.mod_publishers.add_page_title');
        // this.modalTitle = 'mod_manage.mod_publishers.add_page_title';
        this.publisherFetchUrl = this.service.getBaseApiUrl() + '/publisher/ownership';
        this.setAdvSelectConfig();
        this.formGroup = this.formBuilder.group({
            publisher: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_3__["Validators"].compose([_angular_forms__WEBPACK_IMPORTED_MODULE_3__["Validators"].required])],
            application_letter: ['']
        });
        this.setUploadOptions();
    };
    AssignPublisherOwnerComponent.prototype.setAdvSelectConfig = function () {
        this.config.itemTemplate = this.publisherSelectItemTemplate;
        this.config.equalityCheckProperty = 'id';
        this.config.actionButtonEnabled = false;
        this.config.disableEmptyField = false;
        this.config.selectInfoLabel = "Select publisher";
        this.config.emptySelectionTemplate = this.publisherEmptyItemTemplate;
    };
    /**
     * On form submit
     */
    AssignPublisherOwnerComponent.prototype.save = function () {
        var _this = this;
        this.user = this.session.getAuthUser();
        console.log(this.formGroup.value.application_letter);
        var data = {
            publisher: this.formGroup.value.publisher.id,
            user: this.user.id,
            application_letter: this.formGroup.value.application_letter
        };
        var spinner = this.ajaxSpinner.showSpinner();
        this.service.requestPublisherOwnership(data)
            .subscribe(function () {
            spinner.hide();
            _this.showSuccessToast('Request has been sent, you will be contacted soon.');
            //this.formGroup.reset();
            _this.dismisser();
        }, function () {
            spinner.hide();
        });
    };
    /**
     * On cancle
     */
    // public cancel() {
    //  // this.formGroup.reset();
    //   this.dismisser();
    // }
    AssignPublisherOwnerComponent.prototype.onFileUploadComplete = function (event, formControlName) {
        this.formGroup.controls[formControlName].setValue(event.body.path);
    };
    AssignPublisherOwnerComponent.prototype.onPublisherChange = function () {
        //     if (this.publisherModel) {
        //       this.urlParams.publisher = this.publisherModel.id;
        //     } else {
        //       delete this.urlParams.publisher;
        //     }
        //     this.getList();
    };
    __decorate([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ViewChild"])('publisherSelectItemTemplate'),
        __metadata("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__["TemplateRef"])
    ], AssignPublisherOwnerComponent.prototype, "publisherSelectItemTemplate", void 0);
    __decorate([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_0__["ViewChild"])('emptySelectionTemplate'),
        __metadata("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_0__["TemplateRef"])
    ], AssignPublisherOwnerComponent.prototype, "publisherEmptyItemTemplate", void 0);
    AssignPublisherOwnerComponent = __decorate([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_0__["Component"])({
            selector: 'app-assign-publisher-owner',
            template: __webpack_require__(/*! ./assign-publisher-owner.component.html */ "./src/app/admin-module/pages/publishers/components/assign-publisher-owner/assign-publisher-owner.component.html"),
            styleUrls: []
        }),
        __metadata("design:paramtypes", [_angular_core__WEBPACK_IMPORTED_MODULE_0__["Injector"], src_app_system_components_modal_NicoModalController__WEBPACK_IMPORTED_MODULE_1__["NicoModalController"]])
    ], AssignPublisherOwnerComponent);
    return AssignPublisherOwnerComponent;
}(_system_components_modal_AbstractNicoModalComponent__WEBPACK_IMPORTED_MODULE_2__["AbstractNicoModalComponent"]));



/***/ }),

/***/ "./src/app/admin-module/pages/publishers/components/list-request-owner/list-request-owner.component.html":
/*!***************************************************************************************************************!*\
  !*** ./src/app/admin-module/pages/publishers/components/list-request-owner/list-request-owner.component.html ***!
  \***************************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<section class=\"container-fluid component-title-block\">\n  <h2>Request publisher Owner</h2>\n \n</section>\n<section class=\"container-fluid users-container list-view\">\n  <table class=\"table\">\n    <thead class=\"thead custom-table-head\">\n    <tr>\n      <th scope=\"col\">{{'mod_register.name_of_publisher'|translate}}</th>\n      <th scope=\"col\">{{'mod_commons.requested_by'|translate}}</th> \n      <th scope=\"col\">{{'mod_manage.mod_users.email_label'|translate}}</th>\n      <th scope=\"col\">{{'mod_commons.date_label'|translate}}</th>          \n      <th scope=\"col\">{{'mod_commons.action_label'|translate}}</th>\n    </tr>\n    </thead>\n    <tbody class=\"custom-table-body\">\n    <ng-container *ngFor=\"let item of items\">\n      <tr>\n        <td>{{ item.title }}</td>\n        <td> {{ item.user }} </td>\n        <td> {{ item.email}}</td>\n        <td> <nico-date [value]=\"item.created_at\"></nico-date> </td>        \n        <td class=\"d-flex align-items-center on-hover-primary pb-3\" >\n          <!-- <a [routerLink]=\"['/settings']\">Contact Settings</a> <span [tooltip]=\"toolTipContent\" placement=\"top left\" containerClass=\"customTooltip\" container=\"body\">View</span>      -->\n          <button class=\"btn btn-primary  active\" (click) = \"requestOwnerAccepted(item)\" role=\"button\" aria-pressed=\"true\">Accept Request</button>\n <div *ngIf=\"item.application_letter\"><a download class=\"btn-sm btn btn-success\" href=\"{{item.application_letter}}\">Download Doc</a></div>\n\t</td>\n      </tr>\n    </ng-container>\n    </tbody>\n  </table>\n</section>\n<cmp-paginator [currentPage]=\"items.currentPage\" [size]=\"items.total\" [range]=\"10\" [limit]=\"items.perPage\"\n               (pageChange)=\"onPageChange($event)\"></cmp-paginator>\n"

/***/ }),

/***/ "./src/app/admin-module/pages/publishers/components/list-request-owner/list-request-owner.component.ts":
/*!*************************************************************************************************************!*\
  !*** ./src/app/admin-module/pages/publishers/components/list-request-owner/list-request-owner.component.ts ***!
  \*************************************************************************************************************/
/*! exports provided: ListRequestOwnerComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ListRequestOwnerComponent", function() { return ListRequestOwnerComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _system_controllers_BaseComponent__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../../system/controllers/BaseComponent */ "./src/app/system/controllers/BaseComponent.ts");
/* harmony import */ var _services_request_publisher_owner_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../services/request-publisher-owner.service */ "./src/app/admin-module/pages/publishers/services/request-publisher-owner.service.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};



var ListRequestOwnerComponent = /** @class */ (function (_super) {
    __extends(ListRequestOwnerComponent, _super);
    /**
     * Constructor
     * @param injector
     * @param service
     */
    function ListRequestOwnerComponent(injector, service) {
        var _this = _super.call(this, injector) || this;
        _this.service = service;
        return _this;
    }
    /**
     * On init hook
     */
    ListRequestOwnerComponent.prototype.ngOnInit = function () {
        _super.prototype.ngOnInit.call(this);
        this.setPageTitle('Request publisher Owner');
        this.getList();
    };
    ListRequestOwnerComponent.prototype.requestOwnerAccepted = function (item) {
        var _this = this;
        this.appService.showConfirmDialog({
            message: "Are you sure you want to accept the request?",
            onConfirm: function () {
                var spinner = _this.ajaxSpinner.showSpinner();
                var subscription = _this.service.acceptRequest(item).subscribe(function () {
                    if (subscription) {
                        _this.showSuccessToast('Request has been successfully accepted.');
                        subscription.unsubscribe();
                        spinner.hide();
                    }
                    _this.getList();
                }, function () {
                    if (subscription) {
                        subscription.unsubscribe();
                        spinner.hide();
                    }
                });
            }
        });
    };
    ;
    ListRequestOwnerComponent = __decorate([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_0__["Component"])({
            selector: 'app-list-request-owner',
            template: __webpack_require__(/*! ./list-request-owner.component.html */ "./src/app/admin-module/pages/publishers/components/list-request-owner/list-request-owner.component.html")
        }),
        __metadata("design:paramtypes", [_angular_core__WEBPACK_IMPORTED_MODULE_0__["Injector"], _services_request_publisher_owner_service__WEBPACK_IMPORTED_MODULE_2__["RequestPublisherOwnerService"]])
    ], ListRequestOwnerComponent);
    return ListRequestOwnerComponent;
}(_system_controllers_BaseComponent__WEBPACK_IMPORTED_MODULE_1__["BaseComponent"]));



/***/ }),

/***/ "./src/app/admin-module/pages/publishers/components/list-request-publisher/list-request-publisher.component.html":
/*!***********************************************************************************************************************!*\
  !*** ./src/app/admin-module/pages/publishers/components/list-request-publisher/list-request-publisher.component.html ***!
  \***********************************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<section class=\"container-fluid component-title-block\">\n  <h2>Publisher Request List</h2>\n \n</section>\n<section class=\"container-fluid users-container list-view\">\n  <table class=\"table\">\n    <thead class=\"thead custom-table-head\">\n    <tr>\n      <th scope=\"col\">{{'mod_manage.mod_publishers.title_label'|translate}}</th>\n      <th scope=\"col\">{{'mod_manage.mod_users.email_label'|translate}}</th>\n      <th scope=\"col\">{{'mod_commons.date_label'|translate}}</th>\n      <th scope=\"col\">{{'mod_manage.mod_publishers.requested_publishers'|translate}}</th>     \n      <th scope=\"col\">{{'mod_commons.action_label'|translate}}</th>\n    </tr>\n    </thead>\n    <tbody class=\"custom-table-body\">\n    <ng-container *ngFor=\"let item of items\">\n      <tr>\n        <td>{{ item.title }}</td>\n        <td> {{ item.email }} </td>\n        <td> <nico-date [value]=\"item.created_at\"></nico-date> </td>\n        <td> {{ item.user}}</td>\n        <td class=\"d-flex align-items-center on-hover-primary pb-3\" >\n          <!-- <a [routerLink]=\"['/settings']\">Contact Settings</a> <span [tooltip]=\"toolTipContent\" placement=\"top left\" containerClass=\"customTooltip\" container=\"body\">View</span>      -->\n          <a routerLink=\"/manage/publishers/request-publisher/{{ item.id }}/show\" class=\"btn btn-primary  active\" role=\"button\" aria-pressed=\"true\">View Detail</a>\n        </td>\n      </tr>\n    </ng-container>\n    </tbody>\n  </table>\n</section>\n<cmp-paginator [currentPage]=\"items.currentPage\" [size]=\"items.total\" [range]=\"10\" [limit]=\"items.perPage\"\n               (pageChange)=\"onPageChange($event)\"></cmp-paginator>\n"

/***/ }),

/***/ "./src/app/admin-module/pages/publishers/components/list-request-publisher/list-request-publisher.component.ts":
/*!*********************************************************************************************************************!*\
  !*** ./src/app/admin-module/pages/publishers/components/list-request-publisher/list-request-publisher.component.ts ***!
  \*********************************************************************************************************************/
/*! exports provided: ListRequestPublisherComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ListRequestPublisherComponent", function() { return ListRequestPublisherComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _system_controllers_BaseComponent__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../../system/controllers/BaseComponent */ "./src/app/system/controllers/BaseComponent.ts");
/* harmony import */ var _services_request_add_publisher_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../services/request-add-publisher.service */ "./src/app/admin-module/pages/publishers/services/request-add-publisher.service.ts");
/* harmony import */ var _shared_new_user_component_new_user_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../../shared/new-user-component/new-user.component */ "./src/app/shared/new-user-component/new-user.component.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};




var ListRequestPublisherComponent = /** @class */ (function (_super) {
    __extends(ListRequestPublisherComponent, _super);
    /**
     * Constructor
     * @param injector
     * @param service
     */
    function ListRequestPublisherComponent(injector, service) {
        var _this = _super.call(this, injector) || this;
        _this.service = service;
        return _this;
    }
    /**
     * On init hook
     */
    ListRequestPublisherComponent.prototype.ngOnInit = function () {
        _super.prototype.ngOnInit.call(this);
        this.setPageTitle('mod_manage.mod_publishers.requested_publishers');
        this.getList();
        // this.statusLabelConfig = new Collection([
        //   {status: StatusEnum.Unpublished, value: 'mod_commons.inactive_label'},
        //   {status: StatusEnum.Published, value: 'mod_commons.active_label'}
        // ]);
    };
    /**
     * Add new item
     */
    ListRequestPublisherComponent.prototype.newItem = function () {
        var _this = this;
        this.currentService = this.service;
        this.nicoCtrl.create(_shared_new_user_component_new_user_component__WEBPACK_IMPORTED_MODULE_3__["NewUserComponent"], {
            htmlTemplateAsIs: true,
            data: { service: this.currentService },
            modalClass: 'custom-modal custom-modal-540',
            onOkayProcessComplete: function () {
                _this.getList();
            },
            onDestroy: function () {
                _this.setPageTitle('mod_manage.mod_users.page_title');
            },
        }).present();
    };
    ListRequestPublisherComponent = __decorate([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_0__["Component"])({
            selector: 'app-list-request-publisher',
            template: __webpack_require__(/*! ./list-request-publisher.component.html */ "./src/app/admin-module/pages/publishers/components/list-request-publisher/list-request-publisher.component.html")
        }),
        __metadata("design:paramtypes", [_angular_core__WEBPACK_IMPORTED_MODULE_0__["Injector"], _services_request_add_publisher_service__WEBPACK_IMPORTED_MODULE_2__["RequestAddPublisherService"]])
    ], ListRequestPublisherComponent);
    return ListRequestPublisherComponent;
}(_system_controllers_BaseComponent__WEBPACK_IMPORTED_MODULE_1__["BaseComponent"]));



/***/ }),

/***/ "./src/app/admin-module/pages/publishers/components/publisher-list/publishers-list.component.html":
/*!********************************************************************************************************!*\
  !*** ./src/app/admin-module/pages/publishers/components/publisher-list/publishers-list.component.html ***!
  \********************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "\n<section class=\"container-fluid component-title-block\">\n  <h2>{{'mod_manage.mod_publishers.page_title'|translate}}</h2>\n  <div class=\"cta-block\" *ngIf=\"authUser.can('publishers.create')\">\n  <button class=\"btn btn-secondary\" (click)=\"openCreateModel()\">\n    <i class=\"fas fa-plus mr-2\"></i>{{'mod_manage.mod_publishers.add_create_label'|translate}}</button>\n</div>\n  <div class=\"text-warning text-justify\" *ngIf=\"!authUser.can('publishers.create')\">\n    Please click the following link to search the <a href=\"https://isbn.tucl.edu.np/publishers\">publisher information</a> on our database. If your publisher information already exists in the system, please write to <a href=\"mailto:tucl.isbn@gmail.com\">tucl.isbn@gmail.com</a> to request the ISBN Officer to assign you as an authorized person of the publisher. If your pubisher information doesn't exist, please write to <a href=\"mailto:tucl.isbn@gmail.com\">tucl.isbn@gmail.com</a> to request the ISBN Officer to create the publisher information and assign you as an authorized person to that publisher. In order to create a new publisher information, you will have to include the publisher details such as name, address, contact telephone, email, etc. in the email.\n  <button *ngIf=\"!isAdmin\" class=\"btn btn-secondary float-right\" (click)=\"assignOwnereModel()\">Request for Owner</button>\n  </div>\n  <app-advanced-search (update)=\"onSearchChange($event)\" [searchOptions]=\"{statusOptionEnabled: false}\"> </app-advanced-search>\n</section>\n<ng-template [ngIf]='emptyList()'>\n  <section class=\"container-fluid emptylist-container\">\n    <h5 class=\"text-center text-muted\"><i class=\"fa fa-info-circle mr-2\"></i>\n      {{'mod_manage.mod_publishers.no_resources_message'|translate}}</h5>\n  </section>\n</ng-template>\n\n<section >\n  <div class=\"absolute-position-container\">\n    <div class=\"absolute-position-child\">\n      <section class=\"container-fluid items-container block-view\">\n        <div class=\"row\">\n          <ng-container *ngFor=\"let value of items\">\n            <div class=\"col-xl-3 col-lg-4 col-md-6 mb-4\">\n              <div class=\"card hover-card\">\n\n                  <app-action-fly-menu\n                    [status]=\"value.status\"\n                    [placement]=\"'top right'\"\n                    [matIcon]=\"'more_vert'\"\n                    [className]=\"'card-dropdown'\"\n                    (action)=\"onFlyMenuAction($event, value)\"\n                    [options]=\"flyMenuOptions\"\n                    [addOnPrepend]=\"true\"\n                    [addOns]=\"extraFlyMenuItem\"\n                  ></app-action-fly-menu>\n\n                <div class=\"card-body\">\n                  <div class=\"site-header\">\n                    <div class=\"avatar\">\n                      <img *ngIf=\"!value.logo_url\" [src]=\"'/assets/img/avatar.svg'\" [alt]=\"value.title + ' logo'\">\n                      <img *ngIf=\"value.logo_url\" [src]=\"value.logo_url\" [alt]=\"value.title + ' logo'\">\n                    </div>\n                    <div class=\"site-title\">\n                      <a [routerLink]=\"value.id + '/show'\">\n                        <h5 [title]=\"value.title\" [tooltip]=\"toolTipContent\" placement=\"top left\" containerClass=\"customTooltip\" container=\"body\">{{value.title|truncateText:17}}</h5>\n                      </a>\n                      <ng-template #toolTipContent>{{value.title}}</ng-template>\n\n                    </div>\n                  </div>\n                  <div class=\"site-details\">\n                    <div class=\"details\">\n                      <p class=\"custom-text-truncate\" ><i class=\"fa fa-envelope\"></i> {{value.email || 'NA'}}</p>\n                      <p class=\"custom-text-truncate\" ><i class=\"fa fa-phone\"></i> {{value.phone_number || 'NA'}}</p>\n                    </div>\n                  </div>\n                </div>\n                <div class=\"card-footer with-border\" >\n                  <span class=\"custom-text-truncate\" ><i class=\"fa fa-map-pin\"></i> {{value.street || 'NA'}}</span>\n                </div>\n              </div>\n\n            </div>\n          </ng-container>\n        </div>\n      </section>\n      <cmp-paginator [currentPage]=\"items.currentPage\" [size]=\"items.total\" [range]=\"10\" [limit]=\"items.perPage\"\n                     (pageChange)=\"onPageChange($event)\"></cmp-paginator>\n    </div>\n  </div>\n</section>\n\n"

/***/ }),

/***/ "./src/app/admin-module/pages/publishers/components/publisher-list/publishers-list.component.ts":
/*!******************************************************************************************************!*\
  !*** ./src/app/admin-module/pages/publishers/components/publisher-list/publishers-list.component.ts ***!
  \******************************************************************************************************/
/*! exports provided: PublishersListComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PublishersListComponent", function() { return PublishersListComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _system_controllers_BaseComponent__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../../system/controllers/BaseComponent */ "./src/app/system/controllers/BaseComponent.ts");
/* harmony import */ var _services_publisher_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../services/publisher.service */ "./src/app/admin-module/pages/publishers/services/publisher.service.ts");
/* harmony import */ var _add_publisher_add_publisher_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../add-publisher/add-publisher.component */ "./src/app/admin-module/pages/publishers/components/add-publisher/add-publisher.component.ts");
/* harmony import */ var _assign_publisher_owner_assign_publisher_owner_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../assign-publisher-owner/assign-publisher-owner.component */ "./src/app/admin-module/pages/publishers/components/assign-publisher-owner/assign-publisher-owner.component.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};





var PublishersListComponent = /** @class */ (function (_super) {
    __extends(PublishersListComponent, _super);
    function PublishersListComponent(injector, service) {
        var _this = _super.call(this, injector) || this;
        _this.service = service;
        _this.permissionGrpId = (_this.authUser.permissionGroups.all()[0]).perm_grp_id;
        _this.admin = [1, 2];
        _this.extraFlyMenuItem = [{
                label: 'More ...',
                name: 'showMore',
                active: true
            }];
        return _this;
    }
    PublishersListComponent.prototype.setFlyMenu = function () {
        this.flyMenuOptions = {
            disableRemoveItem: !this.authUser.can('publishers.delete'),
            disableStatusItem: true,
            disableEditItem: !this.authUser.can('publishers.update')
        };
    };
    /**
     *  on init lifecycle hook
     */
    PublishersListComponent.prototype.ngOnInit = function () {
        this.isAdmin = (this.admin).includes(this.permissionGrpId);
        _super.prototype.ngOnInit.call(this);
        this.setPageTitle('mod_manage.mod_publishers.page_title');
        this.getList();
        this.setFlyMenu();
    };
    PublishersListComponent.prototype.editItem = function (item) {
        this.openCreateModel(item);
    };
    PublishersListComponent.prototype.onFlyMenuAction = function (evt, item) {
        _super.prototype.onFlyMenuAction.call(this, evt, item);
        if (evt === 'showMore') {
            this.router.navigate(['/manage/publishers/' + item.id + '/show']);
        }
    };
    /**
     * Edit item
     * @param item
     */
    PublishersListComponent.prototype.openCreateModel = function (item) {
        var _this = this;
        this.nicoCtrl.create(_add_publisher_add_publisher_component__WEBPACK_IMPORTED_MODULE_3__["AddPublisherComponent"], {
            htmlTemplateAsIs: true,
            data: { model: item },
            modalClass: 'custom-modal custom-modal-md',
            onOkayProcessComplete: function () {
                _this.getList();
            }
        }).present();
    };
    PublishersListComponent.prototype.assignOwnereModel = function (item) {
        this.nicoCtrl.create(_assign_publisher_owner_assign_publisher_owner_component__WEBPACK_IMPORTED_MODULE_4__["AssignPublisherOwnerComponent"], {
            htmlTemplateAsIs: true,
            // data: {model: item},
            modalClass: 'custom-modal custom-modal-md',
            onOkayProcessComplete: function () {
                //this.getList();
            }
        }).present();
    };
    __decorate([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_0__["Input"])(),
        __metadata("design:type", Boolean)
    ], PublishersListComponent.prototype, "isAdmin", void 0);
    PublishersListComponent = __decorate([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_0__["Component"])({
            selector: 'app-videos-list',
            template: __webpack_require__(/*! ./publishers-list.component.html */ "./src/app/admin-module/pages/publishers/components/publisher-list/publishers-list.component.html"),
        }),
        __metadata("design:paramtypes", [_angular_core__WEBPACK_IMPORTED_MODULE_0__["Injector"],
            _services_publisher_service__WEBPACK_IMPORTED_MODULE_2__["PublisherService"]])
    ], PublishersListComponent);
    return PublishersListComponent;
}(_system_controllers_BaseComponent__WEBPACK_IMPORTED_MODULE_1__["BaseComponent"]));



/***/ }),

/***/ "./src/app/admin-module/pages/publishers/components/publisher-view/pages/prefixes/components/add-prefix.component.html":
/*!*****************************************************************************************************************************!*\
  !*** ./src/app/admin-module/pages/publishers/components/publisher-view/pages/prefixes/components/add-prefix.component.html ***!
  \*****************************************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div class=\"modal-header\">\n  <h4 class=\"modal-title\">\n    <span class=\"modal-title-icon\">\n      <i class=\"fas fa-globe\"></i>\n    </span>\n    {{ modalTitle | translate}}\n  </h4>\n  <button class=\"custom-icon-button\" type=\"button\" aria-label=\"Close\" (click)=\"cancel()\">\n    <i class=\"fas fa-times\"></i>\n  </button>\n</div>\n<section class=\"modal-body\">\n  <form [id]=\"formId\" [formGroup]=\"formGroup\">\n    <div class=\"form-group has-label\">\n      <label for=\"prefix\"\n             class=\"form-control-label\">Prefix</label>\n      <div class=\"input-group\">\n        <section class=\"input-group-prepend\">\n          <!-- <span class=\"input-group-text\">{{isbnAddOn}}</span> -->\n          <select class=\"form-control\" formControlName=\"country_prefix\">\n            <option value=\"\" disabled>country prefix</option>\n            <option *ngFor=\"let country of countryPrefix\" [ngValue]=\"country\">{{country}}</option>\n          </select>\n        </section>\n        <input id=\"prefix\" type=\"text\" formControlName=\"prefix\" autocomplete=\"off\"\n               placeholder = 'Number in the range of 0-2 or 30-49 or 500-799 or 8000-9999 '\n               class=\"form-control\">\n      </div>\n\n    </div>\n    <div class=\"form-group has-label\">\n      <label for=\"effective_date\"\n             class=\"form-control-label\">Effective</label>\n      <input id=\"effective_date\" type=\"text\" formControlName=\"effective_date\"\n             bsDatepicker [bsConfig]=\"{dateInputFormat: 'YYYY-MM-DD'}\"\n             readonly\n             class=\"form-control nico-readonly\">\n    </div>\n  </form>\n\n</section>\n<div class=\"modal-footer\">\n  <button class=\"btn btn-light mr-3\" (click)=\"cancel()\"\n          tabindex=\"2\">{{'mod_commons.cancel_label'|translate}}</button>\n  <button class=\"btn btn-primary\" (click)=\"save()\" tabindex=\"1\"\n          [disabled]=\"!formGroup.valid\">{{'mod_commons.save_label'|translate}}</button>\n</div>\n"

/***/ }),

/***/ "./src/app/admin-module/pages/publishers/components/publisher-view/pages/prefixes/components/add-prefix.component.ts":
/*!***************************************************************************************************************************!*\
  !*** ./src/app/admin-module/pages/publishers/components/publisher-view/pages/prefixes/components/add-prefix.component.ts ***!
  \***************************************************************************************************************************/
/*! exports provided: AddPrefixComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AddPrefixComponent", function() { return AddPrefixComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _system_components_modal_AbstractNicoModalComponent__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../../../../../system/components/modal/AbstractNicoModalComponent */ "./src/app/system/components/modal/AbstractNicoModalComponent.ts");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/forms */ "./node_modules/@angular/forms/fesm5/forms.js");
/* harmony import */ var _services_publisher_prefix_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../../services/publisher-prefix.service */ "./src/app/admin-module/pages/publishers/services/publisher-prefix.service.ts");
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! moment */ "./node_modules/moment/moment.js");
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _environments_environment__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../../../../../../../environments/environment */ "./src/environments/environment.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};






var AddPrefixComponent = /** @class */ (function (_super) {
    __extends(AddPrefixComponent, _super);
    function AddPrefixComponent(injector) {
        var _this = _super.call(this, injector) || this;
        _this.busySaving = false;
        _this.formId = "add-publisher-prefix-form";
        _this.modalTitle = "Add a new prefix";
        _this.isbnAddOn = null;
        _this.countryPrefix = null;
        _this.service = injector.get(_services_publisher_prefix_service__WEBPACK_IMPORTED_MODULE_3__["PublisherPrefixService"]);
        _this.isbnAddOn = _environments_environment__WEBPACK_IMPORTED_MODULE_5__["environment"].country_isbn_identifier;
        _this.countryPrefix = ['99933', '99946', '9789937', '97899933', '97899946'];
        return _this;
    }
    AddPrefixComponent.prototype.ngOnInit = function () {
        _super.prototype.ngOnInit.call(this);
        this.setPageTitle("Add prefix");
        if (this.data.model) {
            this.setPageTitle("Edit prefix");
        }
        this.formGroup = this.formBuilder.group({
            prefix: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_2__["Validators"].compose([_angular_forms__WEBPACK_IMPORTED_MODULE_2__["Validators"].required])],
            effective_date: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_2__["Validators"].compose([_angular_forms__WEBPACK_IMPORTED_MODULE_2__["Validators"].required])],
            country_prefix: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_2__["Validators"].compose([_angular_forms__WEBPACK_IMPORTED_MODULE_2__["Validators"].required])]
        });
        if (this.data.model) {
            var patch = {};
            patch.prefix = this.data.model.prefix;
            patch.country_prefix = this.data.model.country_prefix;
            if (this.data.model.effective_date) {
                patch.effective_date = this.data.model.effective_date.format('YYYY-MM-DD');
            }
            this.formGroup.patchValue(patch);
            this.modalTitle = "Edit prefix";
        }
    };
    /**
     * Save the form data
     */
    AddPrefixComponent.prototype.save = function () {
        var _this = this;
        if (this.busySaving) {
            return;
        }
        var spinner = this.ajaxSpinner.showSpinner();
        this.busySaving = true;
        var data = this.formGroup.value;
        data.effective_date = moment__WEBPACK_IMPORTED_MODULE_4__(data.effective_date).format('YYYY-MM-DD');
        this.service.save(data, this.data.model ? this.data.model.id : null).subscribe(function () {
            spinner.hide();
            _this.busySaving = false;
            _this.okayCompleteListener();
            _this.dismisser();
            if (_this.data.model) {
                _this.showSuccessToast("The selected prefix has been updated successfully.");
            }
            else {
                _this.showSuccessToast("A new prefix has been added successfully.");
            }
        }, function (response) {
            spinner.hide();
            _this.busySaving = false;
            if (!response.status.messageShown) {
                _this.showErrorToast(response.status.message);
            }
            if (response.status.statusCode === 417) {
                _this.validationMessenger.attach(_this.formId, response.body);
            }
        });
    };
    /**
     * Cancel form
     */
    AddPrefixComponent.prototype.cancel = function () {
        this.dismisser();
    };
    AddPrefixComponent = __decorate([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_0__["Component"])({
            selector: 'app-publisher-add-prefix',
            template: __webpack_require__(/*! ./add-prefix.component.html */ "./src/app/admin-module/pages/publishers/components/publisher-view/pages/prefixes/components/add-prefix.component.html"),
        }),
        __metadata("design:paramtypes", [_angular_core__WEBPACK_IMPORTED_MODULE_0__["Injector"]])
    ], AddPrefixComponent);
    return AddPrefixComponent;
}(_system_components_modal_AbstractNicoModalComponent__WEBPACK_IMPORTED_MODULE_1__["AbstractNicoModalComponent"]));



/***/ }),

/***/ "./src/app/admin-module/pages/publishers/components/publisher-view/pages/prefixes/prefixes.component.html":
/*!****************************************************************************************************************!*\
  !*** ./src/app/admin-module/pages/publishers/components/publisher-view/pages/prefixes/prefixes.component.html ***!
  \****************************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<section class=\"container-fluid component-title-block\">\n  <h2>Prefixes of {{ publisherModel }}</h2>\n  <div class=\"cta-block\" *ngIf=\"authUser.can('publisher_prefixes.create')\">\n    <button class=\"btn btn-secondary\" (click)=\"openCreateModel()\">\n      <i class=\"fas fa-plus mr-2\"></i>Add prefix</button>\n  </div>\n</section>\n<ng-template [ngIf]='emptyList()'>\n  <section class=\"container-fluid emptylist-container\">\n    <h5 class=\"text-center text-muted\"><i class=\"fa fa-info-circle mr-2\"></i>No items available.</h5>\n  </section>\n</ng-template>\n<section class=\"container-fluid\">\n  <div class=\"row\" *ngIf=\"items\">\n    <section class=\"col-md-7 \" *ngFor=\"let item of items\">\n      <div class=\"nico-plain-list-item\">\n        <label><span class=\"badge badge-secondary\">{{item.country_prefix}}</span>-{{item.prefix}}</label>\n        <ul class=\"action fa-pull-right\">\n          <li class=\"action-item\" *ngIf=\"item.effective_date\" >\n            <span class=\" badge badge-info\">Effective date: {{item.effective_date.format('YYYY-MM-DD')}}</span>\n          </li>\n          <li class='action-item active' *ngIf=\"item.active\"\n             title=\"Active prefix\"\n          ><span class=\"badge badge-success\">Active</span></li>\n          <li class=\"action-item\" (click)=\"openCreateModel(item)\" *ngIf=\"authUser.can('publisher_prefixes.update')\"><i class=\"fa fa-pen\"></i></li>\n          <li class=\"action-item nico-action-danger\" (click)=\"destroy(item)\"*ngIf=\"authUser.can('publisher_prefixes.delete')\"><i class=\"fa fa-trash\"></i></li>\n        </ul>\n      </div>\n\n    </section>\n  </div>\n\n</section>\n"

/***/ }),

/***/ "./src/app/admin-module/pages/publishers/components/publisher-view/pages/prefixes/prefixes.component.ts":
/*!**************************************************************************************************************!*\
  !*** ./src/app/admin-module/pages/publishers/components/publisher-view/pages/prefixes/prefixes.component.ts ***!
  \**************************************************************************************************************/
/*! exports provided: PrefixesComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PrefixesComponent", function() { return PrefixesComponent; });
/* harmony import */ var _system_controllers_BaseComponent__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../../../system/controllers/BaseComponent */ "./src/app/system/controllers/BaseComponent.ts");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _services_publisher_prefix_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../services/publisher-prefix.service */ "./src/app/admin-module/pages/publishers/services/publisher-prefix.service.ts");
/* harmony import */ var _components_add_prefix_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./components/add-prefix.component */ "./src/app/admin-module/pages/publishers/components/publisher-view/pages/prefixes/components/add-prefix.component.ts");
/* harmony import */ var _environments_environment__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../../../../../environments/environment */ "./src/environments/environment.ts");
/* harmony import */ var _services_publisher_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../../services/publisher.service */ "./src/app/admin-module/pages/publishers/services/publisher.service.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};






var PrefixesComponent = /** @class */ (function (_super) {
    __extends(PrefixesComponent, _super);
    function PrefixesComponent(injector) {
        var _this = _super.call(this, injector) || this;
        _this.urlParams = { page: 1, sort_by: 'prefix', sort_order: 'desc' };
        _this.service = injector.get(_services_publisher_prefix_service__WEBPACK_IMPORTED_MODULE_2__["PublisherPrefixService"]);
        _this.publisherService = injector.get(_services_publisher_service__WEBPACK_IMPORTED_MODULE_5__["PublisherService"]);
        _this.isbnPrefix = _environments_environment__WEBPACK_IMPORTED_MODULE_4__["environment"].country_isbn_identifier;
        return _this;
    }
    PrefixesComponent.prototype.ngOnInit = function () {
        var _this = this;
        _super.prototype.ngOnInit.call(this);
        this.setPageTitle("Prefixes");
        // console.log(this.activatedRoute.parent.params);
        var subscription = this.activatedRoute.parent.params.subscribe(function (params) {
            _this.service.generateResourceUrl({ publisherId: params.id });
            _this.publisherService.find(params.id).subscribe(function (model) {
                _this.publisherModel = model.title;
            });
            _this.getList();
            if (subscription) {
                subscription.unsubscribe();
            }
        });
    };
    /**
     * Edit item
     * @param item
     */
    PrefixesComponent.prototype.openCreateModel = function (item) {
        var _this = this;
        this.nicoCtrl.create(_components_add_prefix_component__WEBPACK_IMPORTED_MODULE_3__["AddPrefixComponent"], {
            htmlTemplateAsIs: true,
            data: { model: item },
            modalClass: 'custom-modal custom-modal-md',
            onOkayProcessComplete: function () {
                _this.getList();
            }
        }).present();
    };
    PrefixesComponent = __decorate([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'app-publisher-prefix',
            template: __webpack_require__(/*! ./prefixes.component.html */ "./src/app/admin-module/pages/publishers/components/publisher-view/pages/prefixes/prefixes.component.html")
        }),
        __metadata("design:paramtypes", [_angular_core__WEBPACK_IMPORTED_MODULE_1__["Injector"]])
    ], PrefixesComponent);
    return PrefixesComponent;
}(_system_controllers_BaseComponent__WEBPACK_IMPORTED_MODULE_0__["BaseComponent"]));



/***/ }),

/***/ "./src/app/admin-module/pages/publishers/components/publisher-view/pages/show/publisher.show.component.html":
/*!******************************************************************************************************************!*\
  !*** ./src/app/admin-module/pages/publishers/components/publisher-view/pages/show/publisher.show.component.html ***!
  \******************************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<section class=\"container-fluid \" *ngIf=\"model\">\n  <button *ngIf=\"!isAdmin\" class=\"btn btn-secondary float-right\" (click)=\"assignOwnereModel()\">Request for Owner</button>\n  <h3 class=\"card-title title-xl\">{{ model.title }}</h3>\n  <div class=\"row\">\n    <section class=\"col-md-4\" id ='owner-selection-section' *ngIf=\"authUser.can('publishers.assign_owner')\">\n      <div><label>{{'mod_manage.mod_publishers.owner_selection_label' | translate}}</label></div>\n      <user-select-input (onSelect)=\"onUserSelect($event)\" [actionBtnEnabled]=\"false\" [value]=\"model.administrator\"></user-select-input>\n    </section>\n    <section class=\"col-md-4\" *ngIf=\"!authUser.can('publishers.assign_owner')\">\n      <div><label>Owner</label></div>\n      <span>{{model?.administrator?.getFullName()}}</span>\n    </section>\n  </div>\n  <br>\n  <div class=\"row mb-2\">\n    <div class=\"col-1\">\n      <img class=\"thumbnail-img\" [src]=\"model.logo_url || '/assets/img/avatar.svg'\" [alt]=\"model.title + 'thumbnail'\" width=\"100\">\n    </div>\n    <section class=\"col-6\">\n      <div class=\"nico-card-item\">\n        <i class=\"fa fa-clipboard\"></i> &nbsp;<span>{{model.title || 'NA'}}</span>\n      </div>\n      <div class=\"nico-card-item\">\n        <i class=\"fa fa-envelope\"></i>&nbsp; <span>{{model.email || 'NA'}}</span>\n      </div>\n      <div class=\"nico-card-item\">\n        <i class=\"fa fa-phone\"></i>&nbsp;<span>{{model.phone_number || 'NA'}}</span>\n      </div>\n      <div class=\"nico-card-item\">\n        <i class=\"fa fa-print\"></i>&nbsp;<span>{{model.fax_number || 'NA'}}</span>\n      </div>\n      <div class=\"nico-card-item\">\n        <i class=\"fa fa-map-pin\"></i>&nbsp;<span>{{model.street || 'NA'}}</span>\n      </div>\n    </section>\n    <section class=\"col-5\">\n      <div class=\"nico-card-item\">\n        <img class=\"thumbnail-img\" [src]=\"model.administrator.company_docs_url || '/assets/img/avatar.svg'\" [alt]=\"model.administrator.first_name + 'thumbnail'\" width=\"100\">\n      </div>\n    </section>\n  </div>\n</section>\n"

/***/ }),

/***/ "./src/app/admin-module/pages/publishers/components/publisher-view/pages/show/publisher.show.component.ts":
/*!****************************************************************************************************************!*\
  !*** ./src/app/admin-module/pages/publishers/components/publisher-view/pages/show/publisher.show.component.ts ***!
  \****************************************************************************************************************/
/*! exports provided: PublisherShowComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PublisherShowComponent", function() { return PublisherShowComponent; });
/* harmony import */ var _system_controllers_BaseComponent__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../../../system/controllers/BaseComponent */ "./src/app/system/controllers/BaseComponent.ts");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _services_publisher_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../services/publisher.service */ "./src/app/admin-module/pages/publishers/services/publisher.service.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};



var PublisherShowComponent = /** @class */ (function (_super) {
    __extends(PublisherShowComponent, _super);
    function PublisherShowComponent(injector) {
        var _this = _super.call(this, injector) || this;
        _this.injector = injector;
        _this.permissionGrpId = (_this.authUser.permissionGroups.all()[0]).perm_grp_id;
        _this.admin = [1, 2];
        _this.service = injector.get(_services_publisher_service__WEBPACK_IMPORTED_MODULE_2__["PublisherService"]);
        return _this;
    }
    PublisherShowComponent.prototype.ngOnInit = function () {
        this.isAdmin = (this.admin).includes(this.permissionGrpId);
        _super.prototype.ngOnInit.call(this);
    };
    /**
     * On route param initialized hook
     */
    PublisherShowComponent.prototype.onRouteParamInitialized = function () {
        this.getResource();
    };
    /**
     * Get the resource
     */
    PublisherShowComponent.prototype.getResource = function () {
        var _this = this;
        var subscription = this.activatedRoute.parent.params.subscribe(function (params) {
            var spinner = _this.ajaxSpinner.showSpinner();
            var fetchSubscription = _this.service.find(params.id, { params: _this.urlParams }).subscribe(function (item) {
                _this.setPageTitle('mod_manage.mod_publishers.edit_page_title', item.title);
                _this.model = item;
                spinner.hide();
                fetchSubscription.unsubscribe();
                subscription.unsubscribe();
            }, function () {
                spinner.hide();
            });
        });
    };
    PublisherShowComponent.prototype.onUserSelect = function ($event) {
        var _this = this;
        this.appService.showConfirmDialog({
            message: "Are you sure you want to change the owner of this publisher?",
            onConfirm: function () {
                var spinner = _this.ajaxSpinner.showSpinner('owner-selection-section');
                if ($event) {
                    _this.service.assignAdministrator(_this.model, $event)
                        .subscribe(function () {
                        spinner.hide();
                    }, function () {
                        spinner.hide();
                    });
                }
                else {
                    _this.service.removeAdministrator(_this.model)
                        .subscribe(function () {
                        spinner.hide();
                    }, function () {
                        spinner.hide();
                    });
                }
            }
        });
    };
    PublisherShowComponent = __decorate([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'app-publisher-show',
            template: __webpack_require__(/*! ./publisher.show.component.html */ "./src/app/admin-module/pages/publishers/components/publisher-view/pages/show/publisher.show.component.html")
        }),
        __metadata("design:paramtypes", [_angular_core__WEBPACK_IMPORTED_MODULE_1__["Injector"]])
    ], PublisherShowComponent);
    return PublisherShowComponent;
}(_system_controllers_BaseComponent__WEBPACK_IMPORTED_MODULE_0__["BaseComponent"]));



/***/ }),

/***/ "./src/app/admin-module/pages/publishers/components/publisher-view/publisher-view.component.html":
/*!*******************************************************************************************************!*\
  !*** ./src/app/admin-module/pages/publishers/components/publisher-view/publisher-view.component.html ***!
  \*******************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div class=\"card\">\n <div class=\"card-body\">\n   <ul class=\"nav navbar-light\">\n     <li class=\"nav-item\" ><a class=\"nav-link\" routerLink=\"show\" routerLinkActive=\"active\">Details</a> </li>\n     <li class=\"nav-item\" ><a class=\"nav-link\" routerLink=\"prefixes\" routerLinkActive=\"active\">Prefixes</a> </li>\n   </ul>\n </div>\n</div>\n<section class=\"card\">\n  <div class=\"card-body\">\n    <router-outlet></router-outlet>\n  </div>\n</section>\n"

/***/ }),

/***/ "./src/app/admin-module/pages/publishers/components/publisher-view/publisher-view.component.scss":
/*!*******************************************************************************************************!*\
  !*** ./src/app/admin-module/pages/publishers/components/publisher-view/publisher-view.component.scss ***!
  \*******************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = ":host .thumbnail-img {\n  width: 100%;\n  max-height: 10rem;\n  -o-object-fit: cover;\n  object-fit: cover; }\n\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi92YXIvd3d3L2h0bWwvaXNibi9yZXNvdXJjZXMvYW5ndWxhci1hcHAvc3JjL2FwcC9hZG1pbi1tb2R1bGUvcGFnZXMvcHVibGlzaGVycy9jb21wb25lbnRzL3B1Ymxpc2hlci12aWV3L3B1Ymxpc2hlci12aWV3LmNvbXBvbmVudC5zY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBRUksWUFBVztFQUNYLGtCQUFpQjtFQUNqQixxQkFBb0I7RUFDcEIsa0JBQWlCLEVBQ2xCIiwiZmlsZSI6InNyYy9hcHAvYWRtaW4tbW9kdWxlL3BhZ2VzL3B1Ymxpc2hlcnMvY29tcG9uZW50cy9wdWJsaXNoZXItdmlldy9wdWJsaXNoZXItdmlldy5jb21wb25lbnQuc2NzcyIsInNvdXJjZXNDb250ZW50IjpbIjpob3N0e1xuICAudGh1bWJuYWlsLWltZ3tcbiAgICB3aWR0aDogMTAwJTtcbiAgICBtYXgtaGVpZ2h0OiAxMHJlbTtcbiAgICAtby1vYmplY3QtZml0OiBjb3ZlcjtcbiAgICBvYmplY3QtZml0OiBjb3ZlcjtcbiAgfVxufVxuIl19 */"

/***/ }),

/***/ "./src/app/admin-module/pages/publishers/components/publisher-view/publisher-view.component.ts":
/*!*****************************************************************************************************!*\
  !*** ./src/app/admin-module/pages/publishers/components/publisher-view/publisher-view.component.ts ***!
  \*****************************************************************************************************/
/*! exports provided: PublisherViewComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PublisherViewComponent", function() { return PublisherViewComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _system_controllers_BaseComponent__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../../system/controllers/BaseComponent */ "./src/app/system/controllers/BaseComponent.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};


var PublisherViewComponent = /** @class */ (function (_super) {
    __extends(PublisherViewComponent, _super);
    function PublisherViewComponent(injector) {
        return _super.call(this, injector) || this;
    }
    PublisherViewComponent = __decorate([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_0__["Component"])({
            selector: 'app-publisher-view',
            template: __webpack_require__(/*! ./publisher-view.component.html */ "./src/app/admin-module/pages/publishers/components/publisher-view/publisher-view.component.html"),
            styles: [__webpack_require__(/*! ./publisher-view.component.scss */ "./src/app/admin-module/pages/publishers/components/publisher-view/publisher-view.component.scss")]
        }),
        __metadata("design:paramtypes", [_angular_core__WEBPACK_IMPORTED_MODULE_0__["Injector"]])
    ], PublisherViewComponent);
    return PublisherViewComponent;
}(_system_controllers_BaseComponent__WEBPACK_IMPORTED_MODULE_1__["BaseComponent"]));



/***/ }),

/***/ "./src/app/admin-module/pages/publishers/components/request-add-publisher/request-add-publisher.component.html":
/*!*********************************************************************************************************************!*\
  !*** ./src/app/admin-module/pages/publishers/components/request-add-publisher/request-add-publisher.component.html ***!
  \*********************************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<section class=\"container-fluid add-user-container\">\n  <div class=\"row mb-4\">\n    <div class=\"col-12\">\n      <div class=\"card add-user-card\">\n        <div class=\"card-header with-border\">\n          <h3 class=\"card-title title-xl\">{{'mod_manage.mod_publishers.page_title'|translate}}</h3>\n        </div>\n        <div class=\"card-body\">\n          <div class=\"row\">\n            <div class=\"col-xl-9 add-user-form pr-xl-5\">\n              <form [id]=\"formId\" [formGroup]=\"requestPublisherFormGroup\">\n                <div class=\"row\">\n                  <div class=\"col-md-12\">\n                    <div class=\"form-group has-label\">\n                      <label class=\"form-control-label\">Publisher Name</label>\n                      <input name=\"title\" formControlName=\"title\" id=\"title\" type=\"text\"\n                      autocomplete=\"off\"\n                      class=\"form-control\">\n                    </div>\n                  </div>\n                </div>\n                <div class=\"row\">\n                  <div class=\"col-md-4\">\n                    <div class=\"form-group has-label\">\n                      <label class=\"form-control-label\"\n                             for=\"street\">{{'mod_manage.mod_publishers.street_label'|translate}}</label>\n                      <input name=\"street\" formControlName=\"street\" id=\"street\" type=\"text\"\n                             autocomplete=\"off\"\n                             class=\"form-control\">\n                    </div>\n                  </div>\n                  <div class=\"col-md-4\">\n                    <div class=\"form-group has-label\">\n                      <label class=\"form-control-label\"\n                             for=\"city\">{{'mod_manage.mod_publishers.city_label'|translate}}</label>\n                      <input name=\"city\" formControlName=\"city\" id=\"city\" type=\"text\"\n                             autocomplete=\"off\"\n                             class=\"form-control\">\n                    </div>\n                  </div>\n                  <div class=\"col-md-4\">\n                    <div class=\"form-group has-label\">\n                      <label class=\"form-control-label\"\n                             for=\"phone_number\">{{'mod_manage.mod_publishers.phone_number_label'|translate}}</label>\n                      <input name='phone_number' formControlName=\"phone_number\" id=\"phone_number\" type=\"text\"\n                             autocomplete=\"off\"\n                             class=\"form-control\">\n                    </div>\n                  </div>\n                </div>\n                <div class=\"row align-items-end\">\n                 <!-- <div class=\"col-md-5\">\n                    <div class=\"form-group has-label\">\n                      <label class=\"form-control-label\"\n                             for=\"fax_number\">{{'mod_manage.mod_publishers.fax_number_label'|translate}}</label>\n                             <input name='fax_number' formControlName=\"fax_number\" id=\"fax_number\" type=\"text\"\n                             autocomplete=\"off\"\n                             [placeholder]=\"'mod_manage.mod_publishers.fax_number_label'|translate\"\n                             class=\"form-control\">\n                    </div>\n\t\t </div> -->\n                  <div class=\"col-md-5\">\n                    <div class=\"form-group has-label\">\n                      <label class=\"form-control-label\"\n                             for=\"email\">{{'mod_manage.mod_publishers.email_label'|translate}}</label>\n                             <input name='email' formControlName=\"email\" id=\"email\" type=\"text\"\n                             autocomplete=\"off\"\n                             class=\"form-control\">\n                    </div>\n                  </div>\n                </div>\n                <div class=\"row\">\n                  <div class=\"col-md-8\">\n                <div class=\"form-group has-label\">\n                  <label [for]=\"'logo_url'\">Logo Image</label>\n                  <cmp-upload-file\n                  [uploadOptions]=\"coverPageUploadOptions\"\n                  (complete)=\"onFileUploadComplete($event, 'logo_url')\"\n                  ></cmp-upload-file>\n                  <a class=\"small\" *ngIf=\"requestPublisherFormGroup.value.logo_url\" (click)=\"viewImage(requestPublisherFormGroup.value.logo_url, 'Logo Image')\">View current</a>\n                </div>\n              </div>\n              </div>\n\t                    <div class=\"row\">\n                <div class=\"col-md-10\">\n                  <div class=\"form-group has-label\">\n                    <label [for]=\"'certificate'\"> Publisher's registration certificate or citizenship certificate</label>\n                    <cmp-upload-file\n                    [uploadOptions]=\"certificatePageUploadOptions\"\n                    (complete)=\"onCertificateUploadComplete($event, 'certificate_url')\"\n                    ></cmp-upload-file>\n                    <a class=\"small\" *ngIf=\"requestPublisherFormGroup.value.certificate_url\" (click)=\"viewImage(requestPublisherFormGroup.value.certificate_url, 'certificate_url')\">View current</a>\n                  </div>\n                </div>\n            </div>\n              </form>\n            </div>\n          </div>\n        </div>\n\n        <div class=\"card-footer with-border\">\n          <button type='submit' class=\"btn btn-primary\" (click)=\"save()\">{{'mod_commons.send_request'|translate}}</button>\n          <!-- <button class=\"btn btn-light\" (click)=\"back()\">{{'mod_commons.close_label'|translate}}</button> -->\n        </div>\n      </div>\n    </div>\n  </div>\n</section>\n"

/***/ }),

/***/ "./src/app/admin-module/pages/publishers/components/request-add-publisher/request-add-publisher.component.ts":
/*!*******************************************************************************************************************!*\
  !*** ./src/app/admin-module/pages/publishers/components/request-add-publisher/request-add-publisher.component.ts ***!
  \*******************************************************************************************************************/
/*! exports provided: RequestAddPublisherComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "RequestAddPublisherComponent", function() { return RequestAddPublisherComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/forms */ "./node_modules/@angular/forms/fesm5/forms.js");
/* harmony import */ var _shared_auth_services_auth_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../../shared/auth/services/auth.service */ "./src/app/shared/auth/services/auth.service.ts");
/* harmony import */ var _services_request_add_publisher_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../services/request-add-publisher.service */ "./src/app/admin-module/pages/publishers/services/request-add-publisher.service.ts");
/* harmony import */ var _system_controllers_BaseComponent__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../../system/controllers/BaseComponent */ "./src/app/system/controllers/BaseComponent.ts");
/* harmony import */ var _shared_enums_permission_options__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../../../shared/enums/permission-options */ "./src/app/shared/enums/permission-options.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};






var RequestAddPublisherComponent = /** @class */ (function (_super) {
    __extends(RequestAddPublisherComponent, _super);
    /**
     * Constructor
     * @param {Injector} injector
     * @param {MeService} service
     * @param {AuthService} authService
     */
    function RequestAddPublisherComponent(injector, service, authService) {
        var _this = _super.call(this, injector) || this;
        _this.service = service;
        _this.authService = authService;
        _this.formId = "requestPublisherForm";
        // public publisher: Publisher;
        _this.thumbUrl = "";
        _this.permissionGroupPermissionOptions = new _shared_enums_permission_options__WEBPACK_IMPORTED_MODULE_5__["PermissionGroupPermissionOptions"]();
        return _this;
    }
    RequestAddPublisherComponent.prototype.avatarUploadStart = function ($event) {
        this.avatarSpinner = this.ajaxSpinner.showSpinner('avatar-container');
    };
    /**
     * Image upload response
     * @param $event
     */
    RequestAddPublisherComponent.prototype.avatarUploadSuccess = function ($event) {
        this.avatarSpinner.hide();
        if ($event.status.code === 'ok') {
            this.requestPublisherFormGroup.controls['image_url'].setValue($event.body.path);
            this.thumbUrl = $event.body.path;
        }
        else {
            this.showErrorToast($event.body.file.pop());
        }
    };
    RequestAddPublisherComponent.prototype.setUploadOptions = function () {
        this.coverPageUploadOptions = {
            title: 'Logo Image',
            instantUpload: true,
            cancellable: false,
            disabledOnComplete: true,
            inputId: 'logo_url',
            hidden: false,
            uploadInputConfig: {
                type: 'uploadAll',
                url: this.service.getBaseApiUrl() + '/upload-resources',
                headers: { 'Authorization': 'Bearer ' + this.session.getToken() },
                method: 'POST',
                fieldName: 'file',
                data: { 'type': 'image' },
            }
        };
        this.certificatePageUploadOptions = {
            title: 'certificate',
            instantUpload: true,
            cancellable: false,
            disabledOnComplete: true,
            inputId: 'certificate_url',
            hidden: false,
            uploadInputConfig: {
                type: 'uploadAll',
                url: this.service.getBaseApiUrl() + '/upload-resources',
                headers: { 'Authorization': 'Bearer ' + this.session.getToken() },
                method: 'POST',
                fieldName: 'file',
                data: { 'type': 'image' },
            }
        };
    };
    /**
     * On init event
     */
    RequestAddPublisherComponent.prototype.ngOnInit = function () {
        this.initRequestForm();
        // this.getAuthUserDetail();
        this.setUploadOptions();
        this.setPageTitle('mod_manage.mod_profile.page_title');
    };
    RequestAddPublisherComponent.prototype.onFileUploadComplete = function (event, formControlName) {
        this.requestPublisherFormGroup.controls[formControlName].setValue(event.body.path);
    };
    RequestAddPublisherComponent.prototype.onCertificateUploadComplete = function (event, formControlName) {
        this.requestPublisherFormGroup.controls[formControlName].setValue(event.body.path);
    };
    // public getAuthUserDetail() {
    //     const spinner: Spinner = this.ajaxSpinner.showSpinner();
    //     this.authService.getAuthUser().subscribe((d: User) => {
    //         this.me = d;
    //         this.thumbUrl = this.me.thumb_url;
    //         this.userFormGroup.patchValue(d);
    //         this.userFormGroup.updateValueAndValidity();
    //         spinner.hide();
    //     }, ( ) =>  {
    //         spinner.hide();
    //     });
    // }
    /**
     * Init profile form
     */
    RequestAddPublisherComponent.prototype.initRequestForm = function () {
        this.requestPublisherFormGroup = this.formBuilder.group({
            title: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required],
            street: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].compose([_angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required])]],
            city: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required],
            phone_number: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required],
            fax_number: [''],
            email: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_1__["Validators"].required],
            logo_url: [''],
            certificate_url: ['']
        });
    };
    /**
     * Open change password modal
     */
    // public openChangePasswordModal() {
    //     this.nicoCtrl.create(EditPasswordComponent, {
    //         showModalHeader: false,
    //         showCrossButton: false,
    //         showModalFooter: false,
    //         modalClass: 'custom-modal',
    //         htmlTemplateAsIs: true
    //     } ).present();
    // }
    RequestAddPublisherComponent.prototype.save = function () {
        var _this = this;
        if (this.busy) {
            return;
        }
        this.busy = true;
        var spinner = this.ajaxSpinner.showSpinner();
        this.service.requestPublisher(this.requestPublisherFormGroup.value)
            .subscribe(function () {
            _this.busy = false;
            spinner.hide();
            _this.showSuccessToast('Request has been sent, you will be contact soon.');
            _this.router.navigate(['/manage/publishers/']);
        }, function (d) {
            _this.busy = false;
            spinner.hide();
            if (d.status.statusCode === 417) {
                _this.validationMessenger.attach(_this.formId, d.body);
            }
        });
    };
    RequestAddPublisherComponent = __decorate([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_0__["Component"])({
            selector: 'app-request-add-publisher',
            template: __webpack_require__(/*! ./request-add-publisher.component.html */ "./src/app/admin-module/pages/publishers/components/request-add-publisher/request-add-publisher.component.html")
        }),
        __metadata("design:paramtypes", [_angular_core__WEBPACK_IMPORTED_MODULE_0__["Injector"], _services_request_add_publisher_service__WEBPACK_IMPORTED_MODULE_3__["RequestAddPublisherService"], _shared_auth_services_auth_service__WEBPACK_IMPORTED_MODULE_2__["AuthService"]])
    ], RequestAddPublisherComponent);
    return RequestAddPublisherComponent;
}(_system_controllers_BaseComponent__WEBPACK_IMPORTED_MODULE_4__["BaseComponent"]));



/***/ }),

/***/ "./src/app/admin-module/pages/publishers/components/view-request-publisher/view-request-publisher.component.html":
/*!***********************************************************************************************************************!*\
  !*** ./src/app/admin-module/pages/publishers/components/view-request-publisher/view-request-publisher.component.html ***!
  \***********************************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<section class=\"container-fluid \" *ngIf=\"model\">\n  <h3 class=\"card-title title-xl\">Requested Publisher</h3>\n\n  <br>\n\n  <div class=\"row mb-2\">\n\n    <section class=\"col-6\">\n\n      <table class=\"table table-borderless\">\n        <tbody>\n          <tr>\n            <td class=\"font-weight-bold\">{{'mod_manage.mod_publishers.title_label'|translate}}</td>\n            <td>{{model.title || 'NA'}}</td>\n          </tr>\n          <tr>\n            <td class=\"font-weight-bold\">{{'mod_manage.mod_publishers.email_label'|translate}}</td>\n            <td>{{model.email || 'NA'}}</td>\n          </tr>\n          <tr>\n            <td class=\"font-weight-bold\">{{'mod_manage.mod_publishers.phone_number_label'|translate}}</td>\n            <td>{{model.phone_number || 'NA'}}</td>\n          </tr>\n          <tr>\n            <td class=\"font-weight-bold\">{{'mod_manage.mod_publishers.street_label'|translate}}</td>\n            <td>{{ model.city + ', ' +  model.street || 'NA'}}</td>\n          </tr>\n          <tr>\n            <td class=\"font-weight-bold\">{{'mod_commons.requested_by'|translate}}</td>\n            <td>{{model.user || 'NA'}}</td>\n          </tr>\n          <tr>\n            <td class=\"font-weight-bold\">{{'mod_commons.requested_on'|translate}}</td>\n            <td>\n              <nico-date [value]=\"model.created_at\"></nico-date>\n            </td>\n          </tr>\n        </tbody>\n      </table>\n    </section>\n    <div class=\"col-2\">\n      <div> Logo of Publisher</div>\n      <img class=\"thumbnail-img\" [src]=\"model.logo_url || '/assets/img/noImage.png'\" [alt]=\"model.title + 'thumbnail'\"\n        width=\"100\">\n      <br><br>\n      <div> Certificate Doc</div>\n      <img class=\"thumbnail-img\" [src]=\"model.certificate_url || '/assets/img/noImage.png'\" [alt]=\"'thumbnail'\"\n        width=\"100\">\n    </div>\n  </div>\n</section>\n<div class=\"col-8 mt-5 float-right\">\n  <button (click)=\"requestAccetp(model)\" type=\"button\" class=\"btn btn-primary\">Request Accept</button>\n</div>\n"

/***/ }),

/***/ "./src/app/admin-module/pages/publishers/components/view-request-publisher/view-request-publisher.component.ts":
/*!*********************************************************************************************************************!*\
  !*** ./src/app/admin-module/pages/publishers/components/view-request-publisher/view-request-publisher.component.ts ***!
  \*********************************************************************************************************************/
/*! exports provided: ViewRequestPublisherComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ViewRequestPublisherComponent", function() { return ViewRequestPublisherComponent; });
/* harmony import */ var _system_controllers_BaseComponent__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../system/controllers/BaseComponent */ "./src/app/system/controllers/BaseComponent.ts");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _services_request_add_publisher_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../services/request-add-publisher.service */ "./src/app/admin-module/pages/publishers/services/request-add-publisher.service.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};



var ViewRequestPublisherComponent = /** @class */ (function (_super) {
    __extends(ViewRequestPublisherComponent, _super);
    function ViewRequestPublisherComponent(injector) {
        var _this = _super.call(this, injector) || this;
        _this.injector = injector;
        _this.service = injector.get(_services_request_add_publisher_service__WEBPACK_IMPORTED_MODULE_2__["RequestAddPublisherService"]);
        return _this;
    }
    ViewRequestPublisherComponent.prototype.ngOnInit = function () {
        _super.prototype.ngOnInit.call(this);
    };
    /**
     * On route param initialized hook
     */
    ViewRequestPublisherComponent.prototype.onRouteParamInitialized = function () {
        this.getResource();
    };
    /**
     * Get the resource
     */
    ViewRequestPublisherComponent.prototype.getResource = function () {
        var _this = this;
        var subscription = this.activatedRoute.params.subscribe(function (params) {
            var spinner = _this.ajaxSpinner.showSpinner();
            var fetchSubscription = _this.service.find(params.id, { params: _this.urlParams }).subscribe(function (item) {
                _this.setPageTitle('mod_manage.mod_publishers.edit_page_title', item.title);
                _this.model = item;
                spinner.hide();
                fetchSubscription.unsubscribe();
                subscription.unsubscribe();
            }, function () {
                spinner.hide();
            });
        });
    };
    ViewRequestPublisherComponent.prototype.requestAccetp = function (item) {
        var _this = this;
        this.appService.showConfirmDialog({
            message: "Are you sure you want to accept the request?",
            onConfirm: function () {
                var spinner = _this.ajaxSpinner.showSpinner();
                var subscription = _this.service.acceptRequest(item).subscribe(function () {
                    if (subscription) {
                        _this.showSuccessToast('Request has been successfully accepted.');
                        subscription.unsubscribe();
                        spinner.hide();
                    }
                    _this.router.navigate(['/manage/publishers/list-request-publisher']);
                }, function () {
                    if (subscription) {
                        subscription.unsubscribe();
                        spinner.hide();
                    }
                });
            }
        });
    };
    ;
    ViewRequestPublisherComponent = __decorate([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
            selector: 'app-view-request-publisher',
            template: __webpack_require__(/*! ./view-request-publisher.component.html */ "./src/app/admin-module/pages/publishers/components/view-request-publisher/view-request-publisher.component.html"),
        }),
        __metadata("design:paramtypes", [_angular_core__WEBPACK_IMPORTED_MODULE_1__["Injector"]])
    ], ViewRequestPublisherComponent);
    return ViewRequestPublisherComponent;
}(_system_controllers_BaseComponent__WEBPACK_IMPORTED_MODULE_0__["BaseComponent"]));



/***/ }),

/***/ "./src/app/admin-module/pages/publishers/models/Publisher.ts":
/*!*******************************************************************!*\
  !*** ./src/app/admin-module/pages/publishers/models/Publisher.ts ***!
  \*******************************************************************/
/*! exports provided: Publisher */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Publisher", function() { return Publisher; });
/* harmony import */ var _shared_base_contituents_publisher_models_BasePublisher__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../shared/base/contituents/publisher/models/BasePublisher */ "./src/app/shared/base/contituents/publisher/models/BasePublisher.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();

var Publisher = /** @class */ (function (_super) {
    __extends(Publisher, _super);
    function Publisher() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return Publisher;
}(_shared_base_contituents_publisher_models_BasePublisher__WEBPACK_IMPORTED_MODULE_0__["BasePublisher"]));



/***/ }),

/***/ "./src/app/admin-module/pages/publishers/models/request-add-publisher.ts":
/*!*******************************************************************************!*\
  !*** ./src/app/admin-module/pages/publishers/models/request-add-publisher.ts ***!
  \*******************************************************************************/
/*! exports provided: RequestAddPublisherModel */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "RequestAddPublisherModel", function() { return RequestAddPublisherModel; });
/* harmony import */ var _system_datamodels_AbstractBaseResource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../system/datamodels/AbstractBaseResource */ "./src/app/system/datamodels/AbstractBaseResource.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();

var RequestAddPublisherModel = /** @class */ (function (_super) {
    __extends(RequestAddPublisherModel, _super);
    function RequestAddPublisherModel() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * The primary key identifier
         * @type {string}
         */
        _this.primaryKey = "id";
        /**
         * The creatable Attributes of the institutions
         */
        _this.creatableAttributes = ['id', 'title', 'street', 'city', 'phone_number', 'fax_number', 'email', 'logo_url', 'user', 'created_at', 'certificate_url'];
        return _this;
    }
    return RequestAddPublisherModel;
}(_system_datamodels_AbstractBaseResource__WEBPACK_IMPORTED_MODULE_0__["AbstractBaseResource"]));



/***/ }),

/***/ "./src/app/admin-module/pages/publishers/models/request-publisher-owner.ts":
/*!*********************************************************************************!*\
  !*** ./src/app/admin-module/pages/publishers/models/request-publisher-owner.ts ***!
  \*********************************************************************************/
/*! exports provided: RequestPublisherOwnerModel */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "RequestPublisherOwnerModel", function() { return RequestPublisherOwnerModel; });
/* harmony import */ var _system_datamodels_AbstractBaseResource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../system/datamodels/AbstractBaseResource */ "./src/app/system/datamodels/AbstractBaseResource.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();

var RequestPublisherOwnerModel = /** @class */ (function (_super) {
    __extends(RequestPublisherOwnerModel, _super);
    function RequestPublisherOwnerModel() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * The primary key identifier
         * @type {string}
         */
        _this.primaryKey = "id";
        /**
         * The creatable Attributes of the institutions
         */
        _this.creatableAttributes = ['id', 'publisher', 'user', 'created_at', 'email', 'title', 'application_letter'];
        return _this;
    }
    return RequestPublisherOwnerModel;
}(_system_datamodels_AbstractBaseResource__WEBPACK_IMPORTED_MODULE_0__["AbstractBaseResource"]));



/***/ }),

/***/ "./src/app/admin-module/pages/publishers/publishers-routing.module.ts":
/*!****************************************************************************!*\
  !*** ./src/app/admin-module/pages/publishers/publishers-routing.module.ts ***!
  \****************************************************************************/
/*! exports provided: PublishersRoutingModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PublishersRoutingModule", function() { return PublishersRoutingModule; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/fesm5/router.js");
/* harmony import */ var _publishers_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./publishers.component */ "./src/app/admin-module/pages/publishers/publishers.component.ts");
/* harmony import */ var _components_publisher_list_publishers_list_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./components/publisher-list/publishers-list.component */ "./src/app/admin-module/pages/publishers/components/publisher-list/publishers-list.component.ts");
/* harmony import */ var _components_publisher_view_publisher_view_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./components/publisher-view/publisher-view.component */ "./src/app/admin-module/pages/publishers/components/publisher-view/publisher-view.component.ts");
/* harmony import */ var _components_publisher_view_pages_show_publisher_show_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./components/publisher-view/pages/show/publisher.show.component */ "./src/app/admin-module/pages/publishers/components/publisher-view/pages/show/publisher.show.component.ts");
/* harmony import */ var _components_publisher_view_pages_prefixes_prefixes_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./components/publisher-view/pages/prefixes/prefixes.component */ "./src/app/admin-module/pages/publishers/components/publisher-view/pages/prefixes/prefixes.component.ts");
/* harmony import */ var _components_request_add_publisher_request_add_publisher_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./components/request-add-publisher/request-add-publisher.component */ "./src/app/admin-module/pages/publishers/components/request-add-publisher/request-add-publisher.component.ts");
/* harmony import */ var _components_list_request_publisher_list_request_publisher_component__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./components/list-request-publisher/list-request-publisher.component */ "./src/app/admin-module/pages/publishers/components/list-request-publisher/list-request-publisher.component.ts");
/* harmony import */ var _components_view_request_publisher_view_request_publisher_component__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./components/view-request-publisher/view-request-publisher.component */ "./src/app/admin-module/pages/publishers/components/view-request-publisher/view-request-publisher.component.ts");
/* harmony import */ var _components_list_request_owner_list_request_owner_component__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./components/list-request-owner/list-request-owner.component */ "./src/app/admin-module/pages/publishers/components/list-request-owner/list-request-owner.component.ts");
/* harmony import */ var _components_assign_publisher_owner_assign_publisher_owner_component__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./components/assign-publisher-owner/assign-publisher-owner.component */ "./src/app/admin-module/pages/publishers/components/assign-publisher-owner/assign-publisher-owner.component.ts");
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};












var PublishersRoutingModule = /** @class */ (function () {
    function PublishersRoutingModule() {
    }
    PublishersRoutingModule = __decorate([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_0__["NgModule"])({
            imports: [
                _angular_router__WEBPACK_IMPORTED_MODULE_1__["RouterModule"].forChild([
                    {
                        path: '',
                        component: _publishers_component__WEBPACK_IMPORTED_MODULE_2__["PublishersComponent"],
                        children: [
                            {
                                path: '',
                                component: _components_publisher_list_publishers_list_component__WEBPACK_IMPORTED_MODULE_3__["PublishersListComponent"],
                            },
                            {
                                path: 'publisher-owner',
                                component: _components_assign_publisher_owner_assign_publisher_owner_component__WEBPACK_IMPORTED_MODULE_11__["AssignPublisherOwnerComponent"],
                            },
                            {
                                path: 'request-publisher',
                                component: _components_request_add_publisher_request_add_publisher_component__WEBPACK_IMPORTED_MODULE_7__["RequestAddPublisherComponent"]
                            },
                            {
                                path: 'list-request-publisher',
                                component: _components_list_request_publisher_list_request_publisher_component__WEBPACK_IMPORTED_MODULE_8__["ListRequestPublisherComponent"]
                            },
                            {
                                path: 'request-publisher/:id/show',
                                component: _components_view_request_publisher_view_request_publisher_component__WEBPACK_IMPORTED_MODULE_9__["ViewRequestPublisherComponent"],
                            },
                            {
                                path: 'list-request-owner',
                                component: _components_list_request_owner_list_request_owner_component__WEBPACK_IMPORTED_MODULE_10__["ListRequestOwnerComponent"],
                            },
                            {
                                path: ':id',
                                component: _components_publisher_view_publisher_view_component__WEBPACK_IMPORTED_MODULE_4__["PublisherViewComponent"],
                                data: { animation: 'default' },
                                children: [
                                    {
                                        path: 'show',
                                        component: _components_publisher_view_pages_show_publisher_show_component__WEBPACK_IMPORTED_MODULE_5__["PublisherShowComponent"]
                                    },
                                    {
                                        path: 'prefixes',
                                        component: _components_publisher_view_pages_prefixes_prefixes_component__WEBPACK_IMPORTED_MODULE_6__["PrefixesComponent"]
                                    }
                                ]
                            },
                        ]
                    },
                ]),
            ],
            exports: [_angular_router__WEBPACK_IMPORTED_MODULE_1__["RouterModule"]]
        })
    ], PublishersRoutingModule);
    return PublishersRoutingModule;
}());



/***/ }),

/***/ "./src/app/admin-module/pages/publishers/publishers.component.html":
/*!*************************************************************************!*\
  !*** ./src/app/admin-module/pages/publishers/publishers.component.html ***!
  \*************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<div class=\"host-wrapper\">\n    <div [@routeAnimations]=\"prepareRoute(outlet)\" >\n        <router-outlet #outlet=\"outlet\"></router-outlet>\n    </div>\n</div>\n"

/***/ }),

/***/ "./src/app/admin-module/pages/publishers/publishers.component.ts":
/*!***********************************************************************!*\
  !*** ./src/app/admin-module/pages/publishers/publishers.component.ts ***!
  \***********************************************************************/
/*! exports provided: PublishersComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PublishersComponent", function() { return PublishersComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _services_publisher_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./services/publisher.service */ "./src/app/admin-module/pages/publishers/services/publisher.service.ts");
/* harmony import */ var _system_controllers_BaseComponent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../system/controllers/BaseComponent */ "./src/app/system/controllers/BaseComponent.ts");
/* harmony import */ var _system_animations__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../system/animations */ "./src/app/system/animations/index.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};




var PublishersComponent = /** @class */ (function (_super) {
    __extends(PublishersComponent, _super);
    function PublishersComponent(injector, service) {
        var _this = _super.call(this, injector) || this;
        _this.service = service;
        return _this;
    }
    /**
     * Get the names OnInit
     */
    PublishersComponent.prototype.ngOnInit = function () {
        this.setPageTitle('Publishers');
    };
    /**
     *  the Method that is called after route param is initialized
     *  If you need to grab something from route and then initialize component. Define them here.
     *  Note, this method will be called every-time if url is changed. So use it wisely.
     */
    PublishersComponent.prototype.onRouteParamInitialized = function () {
    };
    PublishersComponent.prototype.prepareRoute = function (outlet) {
        return outlet && outlet.activatedRouteData;
    };
    PublishersComponent = __decorate([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_0__["Component"])({
            //moduleId: module.id,
            selector: 'app-publishers',
            template: __webpack_require__(/*! ./publishers.component.html */ "./src/app/admin-module/pages/publishers/publishers.component.html"),
            styleUrls: [],
            animations: [_system_animations__WEBPACK_IMPORTED_MODULE_3__["slideInAnimation"]]
        }),
        __metadata("design:paramtypes", [_angular_core__WEBPACK_IMPORTED_MODULE_0__["Injector"], _services_publisher_service__WEBPACK_IMPORTED_MODULE_1__["PublisherService"]])
    ], PublishersComponent);
    return PublishersComponent;
}(_system_controllers_BaseComponent__WEBPACK_IMPORTED_MODULE_2__["BaseComponent"]));



/***/ }),

/***/ "./src/app/admin-module/pages/publishers/publishers.module.ts":
/*!********************************************************************!*\
  !*** ./src/app/admin-module/pages/publishers/publishers.module.ts ***!
  \********************************************************************/
/*! exports provided: PublishersModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PublishersModule", function() { return PublishersModule; });
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/common */ "./node_modules/@angular/common/fesm5/common.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _shared_shared_module__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../shared/shared.module */ "./src/app/shared/shared.module.ts");
/* harmony import */ var _publishers_routing_module__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./publishers-routing.module */ "./src/app/admin-module/pages/publishers/publishers-routing.module.ts");
/* harmony import */ var _request_publisher_routing_module__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./request-publisher-routing.module */ "./src/app/admin-module/pages/publishers/request-publisher-routing.module.ts");
/* harmony import */ var _publishers_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./publishers.component */ "./src/app/admin-module/pages/publishers/publishers.component.ts");
/* harmony import */ var _services_publisher_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./services/publisher.service */ "./src/app/admin-module/pages/publishers/services/publisher.service.ts");
/* harmony import */ var _components_publisher_list_publishers_list_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./components/publisher-list/publishers-list.component */ "./src/app/admin-module/pages/publishers/components/publisher-list/publishers-list.component.ts");
/* harmony import */ var _components_add_publisher_add_publisher_component__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./components/add-publisher/add-publisher.component */ "./src/app/admin-module/pages/publishers/components/add-publisher/add-publisher.component.ts");
/* harmony import */ var _components_publisher_view_publisher_view_component__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./components/publisher-view/publisher-view.component */ "./src/app/admin-module/pages/publishers/components/publisher-view/publisher-view.component.ts");
/* harmony import */ var _components_publisher_view_pages_show_publisher_show_component__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./components/publisher-view/pages/show/publisher.show.component */ "./src/app/admin-module/pages/publishers/components/publisher-view/pages/show/publisher.show.component.ts");
/* harmony import */ var _components_publisher_view_pages_prefixes_prefixes_component__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./components/publisher-view/pages/prefixes/prefixes.component */ "./src/app/admin-module/pages/publishers/components/publisher-view/pages/prefixes/prefixes.component.ts");
/* harmony import */ var _services_publisher_prefix_service__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./services/publisher-prefix.service */ "./src/app/admin-module/pages/publishers/services/publisher-prefix.service.ts");
/* harmony import */ var _services_request_add_publisher_service__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./services/request-add-publisher.service */ "./src/app/admin-module/pages/publishers/services/request-add-publisher.service.ts");
/* harmony import */ var _services_request_publisher_owner_service__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./services/request-publisher-owner.service */ "./src/app/admin-module/pages/publishers/services/request-publisher-owner.service.ts");
/* harmony import */ var _components_publisher_view_pages_prefixes_components_add_prefix_component__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./components/publisher-view/pages/prefixes/components/add-prefix.component */ "./src/app/admin-module/pages/publishers/components/publisher-view/pages/prefixes/components/add-prefix.component.ts");
/* harmony import */ var _components_request_add_publisher_request_add_publisher_component__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./components/request-add-publisher/request-add-publisher.component */ "./src/app/admin-module/pages/publishers/components/request-add-publisher/request-add-publisher.component.ts");
/* harmony import */ var _components_list_request_owner_list_request_owner_component__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./components/list-request-owner/list-request-owner.component */ "./src/app/admin-module/pages/publishers/components/list-request-owner/list-request-owner.component.ts");
/* harmony import */ var _components_view_request_publisher_view_request_publisher_component__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./components/view-request-publisher/view-request-publisher.component */ "./src/app/admin-module/pages/publishers/components/view-request-publisher/view-request-publisher.component.ts");
/* harmony import */ var _components_list_request_publisher_list_request_publisher_component__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./components/list-request-publisher/list-request-publisher.component */ "./src/app/admin-module/pages/publishers/components/list-request-publisher/list-request-publisher.component.ts");
/* harmony import */ var _components_assign_publisher_owner_assign_publisher_owner_component__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./components/assign-publisher-owner/assign-publisher-owner.component */ "./src/app/admin-module/pages/publishers/components/assign-publisher-owner/assign-publisher-owner.component.ts");
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
















//import { RequestPublisherComponent } from './components/request-publisher/request-publisher.component';





var PublishersModule = /** @class */ (function () {
    function PublishersModule() {
    }
    PublishersModule = __decorate([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"])({
            imports: [_angular_common__WEBPACK_IMPORTED_MODULE_0__["CommonModule"], _publishers_routing_module__WEBPACK_IMPORTED_MODULE_3__["PublishersRoutingModule"], _request_publisher_routing_module__WEBPACK_IMPORTED_MODULE_4__["RequestPublisherRoutingModule"], _shared_shared_module__WEBPACK_IMPORTED_MODULE_2__["SharedModule"].forRoot()],
            declarations: [_publishers_component__WEBPACK_IMPORTED_MODULE_5__["PublishersComponent"], _components_publisher_list_publishers_list_component__WEBPACK_IMPORTED_MODULE_7__["PublishersListComponent"], _components_add_publisher_add_publisher_component__WEBPACK_IMPORTED_MODULE_8__["AddPublisherComponent"],
                _components_publisher_view_pages_show_publisher_show_component__WEBPACK_IMPORTED_MODULE_10__["PublisherShowComponent"],
                _components_publisher_view_pages_prefixes_prefixes_component__WEBPACK_IMPORTED_MODULE_11__["PrefixesComponent"],
                _components_publisher_view_pages_prefixes_components_add_prefix_component__WEBPACK_IMPORTED_MODULE_15__["AddPrefixComponent"],
                _components_publisher_view_publisher_view_component__WEBPACK_IMPORTED_MODULE_9__["PublisherViewComponent"],
                //   RequestPublisherComponent,
                _components_request_add_publisher_request_add_publisher_component__WEBPACK_IMPORTED_MODULE_16__["RequestAddPublisherComponent"],
                _components_list_request_owner_list_request_owner_component__WEBPACK_IMPORTED_MODULE_17__["ListRequestOwnerComponent"],
                _components_view_request_publisher_view_request_publisher_component__WEBPACK_IMPORTED_MODULE_18__["ViewRequestPublisherComponent"],
                _components_list_request_publisher_list_request_publisher_component__WEBPACK_IMPORTED_MODULE_19__["ListRequestPublisherComponent"],
                _components_assign_publisher_owner_assign_publisher_owner_component__WEBPACK_IMPORTED_MODULE_20__["AssignPublisherOwnerComponent"]],
            exports: [],
            entryComponents: [_components_add_publisher_add_publisher_component__WEBPACK_IMPORTED_MODULE_8__["AddPublisherComponent"], _components_publisher_view_pages_prefixes_components_add_prefix_component__WEBPACK_IMPORTED_MODULE_15__["AddPrefixComponent"], _components_assign_publisher_owner_assign_publisher_owner_component__WEBPACK_IMPORTED_MODULE_20__["AssignPublisherOwnerComponent"]],
            providers: [_services_publisher_service__WEBPACK_IMPORTED_MODULE_6__["PublisherService"], _services_publisher_prefix_service__WEBPACK_IMPORTED_MODULE_12__["PublisherPrefixService"], _services_request_add_publisher_service__WEBPACK_IMPORTED_MODULE_13__["RequestAddPublisherService"], _services_request_publisher_owner_service__WEBPACK_IMPORTED_MODULE_14__["RequestPublisherOwnerService"]]
        })
    ], PublishersModule);
    return PublishersModule;
}());



/***/ }),

/***/ "./src/app/admin-module/pages/publishers/request-publisher-routing.module.ts":
/*!***********************************************************************************!*\
  !*** ./src/app/admin-module/pages/publishers/request-publisher-routing.module.ts ***!
  \***********************************************************************************/
/*! exports provided: RequestPublisherRoutingModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "RequestPublisherRoutingModule", function() { return RequestPublisherRoutingModule; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/fesm5/router.js");
/* harmony import */ var _components_request_add_publisher_request_add_publisher_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./components/request-add-publisher/request-add-publisher.component */ "./src/app/admin-module/pages/publishers/components/request-add-publisher/request-add-publisher.component.ts");
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};



var RequestPublisherRoutingModule = /** @class */ (function () {
    function RequestPublisherRoutingModule() {
    }
    RequestPublisherRoutingModule = __decorate([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_0__["NgModule"])({
            imports: [
                _angular_router__WEBPACK_IMPORTED_MODULE_1__["RouterModule"].forChild([
                    {
                        path: '',
                        component: _components_request_add_publisher_request_add_publisher_component__WEBPACK_IMPORTED_MODULE_2__["RequestAddPublisherComponent"],
                    },
                ])
            ],
            exports: [_angular_router__WEBPACK_IMPORTED_MODULE_1__["RouterModule"]]
        })
    ], RequestPublisherRoutingModule);
    return RequestPublisherRoutingModule;
}());



/***/ }),

/***/ "./src/app/admin-module/pages/publishers/services/publisher-prefix.service.ts":
/*!************************************************************************************!*\
  !*** ./src/app/admin-module/pages/publishers/services/publisher-prefix.service.ts ***!
  \************************************************************************************/
/*! exports provided: PublisherPrefixService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PublisherPrefixService", function() { return PublisherPrefixService; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _system_services_BaseService__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../system/services/BaseService */ "./src/app/system/services/BaseService.ts");
/* harmony import */ var _system_requests_NicoHttp__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../system/requests/NicoHttp */ "./src/app/system/requests/NicoHttp.ts");
/* harmony import */ var _environments_environment__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../../environments/environment */ "./src/environments/environment.ts");
/* harmony import */ var _shared_base_contituents_publisher_models_BasePublisherPrefix__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../shared/base/contituents/publisher/models/BasePublisherPrefix */ "./src/app/shared/base/contituents/publisher/models/BasePublisherPrefix.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};





var PublisherPrefixService = /** @class */ (function (_super) {
    __extends(PublisherPrefixService, _super);
    /**
     * Constructor
     * @param http
     */
    function PublisherPrefixService(http) {
        var _this = _super.call(this, http, _environments_environment__WEBPACK_IMPORTED_MODULE_3__["environment"]) || this;
        _this.http = http;
        /**
         * The resource
         * @type {string}
         */
        _this.resourceName = 'publishers/{publisherId}/prefixes';
        /**
         * Base resource url
         * @type {string}
         */
        _this.resourceBaseUrl = '';
        _this.resource = new _shared_base_contituents_publisher_models_BasePublisherPrefix__WEBPACK_IMPORTED_MODULE_4__["BasePublisherPrefix"]();
        _this.setResourceName(_this.resourceName);
        return _this;
    }
    PublisherPrefixService = __decorate([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_0__["Injectable"])(),
        __metadata("design:paramtypes", [_system_requests_NicoHttp__WEBPACK_IMPORTED_MODULE_2__["NicoHttp"]])
    ], PublisherPrefixService);
    return PublisherPrefixService;
}(_system_services_BaseService__WEBPACK_IMPORTED_MODULE_1__["BaseService"]));



/***/ }),

/***/ "./src/app/admin-module/pages/publishers/services/publisher.service.ts":
/*!*****************************************************************************!*\
  !*** ./src/app/admin-module/pages/publishers/services/publisher.service.ts ***!
  \*****************************************************************************/
/*! exports provided: PublisherService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PublisherService", function() { return PublisherService; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _system_services_BaseService__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../system/services/BaseService */ "./src/app/system/services/BaseService.ts");
/* harmony import */ var _system_requests_NicoHttp__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../system/requests/NicoHttp */ "./src/app/system/requests/NicoHttp.ts");
/* harmony import */ var _models_Publisher__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../models/Publisher */ "./src/app/admin-module/pages/publishers/models/Publisher.ts");
/* harmony import */ var _environments_environment__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../../environments/environment */ "./src/environments/environment.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};





var PublisherService = /** @class */ (function (_super) {
    __extends(PublisherService, _super);
    /**
     * Constructor
     * @param http
     */
    function PublisherService(http) {
        var _this = _super.call(this, http, _environments_environment__WEBPACK_IMPORTED_MODULE_4__["environment"]) || this;
        _this.http = http;
        /**
         * The resource
         * @type {string}
         */
        _this.resourceName = 'publishers';
        /**
         * Base resource url
         * @type {string}
         */
        _this.resourceBaseUrl = '';
        _this.resource = new _models_Publisher__WEBPACK_IMPORTED_MODULE_3__["Publisher"]();
        _this.setResourceName(_this.resourceName);
        return _this;
    }
    PublisherService.prototype.assignAdministrator = function (publisher, user) {
        return this.http.put(this.resourceBaseUrl + '/' + publisher.id + '/administrator/' + user.id, null);
    };
    PublisherService.prototype.removeAdministrator = function (publisher) {
        return this.http.delete(this.resourceBaseUrl + '/' + publisher.id + '/administrator');
    };
    PublisherService.prototype.requestPublisherOwnership = function (data) {
        return this.http.post(this.resourceBaseUrl + '/request-publisher-owner/create-wonership', data);
    };
    PublisherService = __decorate([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_0__["Injectable"])(),
        __metadata("design:paramtypes", [_system_requests_NicoHttp__WEBPACK_IMPORTED_MODULE_2__["NicoHttp"]])
    ], PublisherService);
    return PublisherService;
}(_system_services_BaseService__WEBPACK_IMPORTED_MODULE_1__["BaseService"]));



/***/ }),

/***/ "./src/app/admin-module/pages/publishers/services/request-add-publisher.service.ts":
/*!*****************************************************************************************!*\
  !*** ./src/app/admin-module/pages/publishers/services/request-add-publisher.service.ts ***!
  \*****************************************************************************************/
/*! exports provided: RequestAddPublisherService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "RequestAddPublisherService", function() { return RequestAddPublisherService; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _system_services_BaseService__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../system/services/BaseService */ "./src/app/system/services/BaseService.ts");
/* harmony import */ var _system_requests_NicoHttp__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../system/requests/NicoHttp */ "./src/app/system/requests/NicoHttp.ts");
/* harmony import */ var _models_request_add_publisher__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../models/request-add-publisher */ "./src/app/admin-module/pages/publishers/models/request-add-publisher.ts");
/* harmony import */ var _environments_environment__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../../environments/environment */ "./src/environments/environment.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};





var RequestAddPublisherService = /** @class */ (function (_super) {
    __extends(RequestAddPublisherService, _super);
    /**
     * Constructor
     * @param http
     */
    function RequestAddPublisherService(http) {
        var _this = _super.call(this, http, _environments_environment__WEBPACK_IMPORTED_MODULE_4__["environment"]) || this;
        _this.http = http;
        /**
         * The resource
         * @type {string}
         */
        _this.resourceName = 'publisher/request-publishers-list';
        /**
         * Base resource url
         * @type {string}
         */
        _this.resourceBaseUrl = '';
        _this.resource = new _models_request_add_publisher__WEBPACK_IMPORTED_MODULE_3__["RequestAddPublisherModel"]();
        _this.setResourceName(_this.resourceName);
        return _this;
    }
    RequestAddPublisherService.prototype.requestPublisher = function (input) {
        return this.http.post(this.getBaseApiUrl() + '/publisher/request-publisher', input);
    };
    RequestAddPublisherService.prototype.acceptRequest = function (data) {
        return this.http.put(this.getBaseApiUrl() + '/publisher/request-accept/' + data.id, null);
    };
    RequestAddPublisherService = __decorate([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_0__["Injectable"])(),
        __metadata("design:paramtypes", [_system_requests_NicoHttp__WEBPACK_IMPORTED_MODULE_2__["NicoHttp"]])
    ], RequestAddPublisherService);
    return RequestAddPublisherService;
}(_system_services_BaseService__WEBPACK_IMPORTED_MODULE_1__["BaseService"]));



/***/ }),

/***/ "./src/app/admin-module/pages/publishers/services/request-publisher-owner.service.ts":
/*!*******************************************************************************************!*\
  !*** ./src/app/admin-module/pages/publishers/services/request-publisher-owner.service.ts ***!
  \*******************************************************************************************/
/*! exports provided: RequestPublisherOwnerService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "RequestPublisherOwnerService", function() { return RequestPublisherOwnerService; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm5/core.js");
/* harmony import */ var _system_services_BaseService__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../system/services/BaseService */ "./src/app/system/services/BaseService.ts");
/* harmony import */ var _system_requests_NicoHttp__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../system/requests/NicoHttp */ "./src/app/system/requests/NicoHttp.ts");
/* harmony import */ var _models_request_publisher_owner__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../models/request-publisher-owner */ "./src/app/admin-module/pages/publishers/models/request-publisher-owner.ts");
/* harmony import */ var _environments_environment__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../../environments/environment */ "./src/environments/environment.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (undefined && undefined.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};





var RequestPublisherOwnerService = /** @class */ (function (_super) {
    __extends(RequestPublisherOwnerService, _super);
    /**
     * Constructor
     * @param http
     */
    function RequestPublisherOwnerService(http) {
        var _this = _super.call(this, http, _environments_environment__WEBPACK_IMPORTED_MODULE_4__["environment"]) || this;
        _this.http = http;
        /**
         * The resource
         * @type {string}
         */
        _this.resourceName = 'publisher/request-publisher-owner';
        /**
         * Base resource url
         * @type {string}
         */
        _this.resourceBaseUrl = '';
        _this.resource = new _models_request_publisher_owner__WEBPACK_IMPORTED_MODULE_3__["RequestPublisherOwnerModel"]();
        _this.setResourceName(_this.resourceName);
        return _this;
    }
    // public requestPublisher(input): Observable<any> {
    //   return this.http.post(this.getBaseApiUrl() + '/publisher/request-publisher-owner', input);
    // }
    RequestPublisherOwnerService.prototype.acceptRequest = function (data) {
        return this.http.put(this.getBaseApiUrl() + '/publisher/request-publisher-owner/request-accept/' + data.id, null);
    };
    RequestPublisherOwnerService = __decorate([
        Object(_angular_core__WEBPACK_IMPORTED_MODULE_0__["Injectable"])(),
        __metadata("design:paramtypes", [_system_requests_NicoHttp__WEBPACK_IMPORTED_MODULE_2__["NicoHttp"]])
    ], RequestPublisherOwnerService);
    return RequestPublisherOwnerService;
}(_system_services_BaseService__WEBPACK_IMPORTED_MODULE_1__["BaseService"]));



/***/ })

}]);
//# sourceMappingURL=pages-publishers-publishers-module.js.map
