<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUserExplicitPermissionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create(\NicoAuth\NicoAuth::TABLE_USE_EXPLICIT_PERMISSION, function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('user_id');
            $table->string('namespace')->note('Namespaces will determine which module/sub-module does this permission belongs to. Default is app');
            $table->string('namespace_id')->nullable()->note('If the namespace value is other than app then this namespace id must be supplied.');
            $table->text('explicit_permission');
            $table->text('group_permission')->nullable();
            $table->foreign('user_id')->references('id')->on('users');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists(\NicoAuth\NicoAuth::TABLE_USE_EXPLICIT_PERMISSION);
    }
}
