<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePermissionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create(\NicoAuth\NicoAuth::TABLE_PERMISSION, function (Blueprint $table) {
            $table->increments('perm_id');
            $table->string('namespace')->note('Namespaces will determine which module/sub-module does this permission belongs to. Default is app');
            $table->string('key');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists(\NicoAuth\NicoAuth::TABLE_PERMISSION);
    }
}
