<?php
/**
 * Created by PhpStorm.
 * User: amar
 * Date: 2/25/18
 * Time: 12:53 PM
 */

namespace NicoAuth\database\Model;


use App\System\UAC\Scopes\NonRootPermissionGroup;
use App\System\User\Database\Scopes\NonRootUser;
use Illuminate\Database\Eloquent\SoftDeletes;
use NicoAuth\NicoAuth;
use NicoAuth\Permission;
use NicoSystem\Foundation\Database\BaseModel;

/**
 * Class PermissionGroup
 * @package NicoAuth\database\Model
 */
class PermissionGroup extends BaseModel
{
    use SoftDeletes;

    protected $hidden = ['deleted_at','updated_by','created_by','deleted_by','pivot'];

    protected $primaryKey = "perm_grp_id";

    protected $permissionValues;

    protected static function boot()
    {
        parent::boot();
        self::addGlobalScope(new NonRootPermissionGroup());
    }

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $this->table = NicoAuth::TABLE_PERMISSION_GROUP;

    }

    public function getOriginalPermissionValue () {
        return $this->attributes['permission'];
    }

    /**
     * @return Permission
     */
    public function getPermissionAttribute(){
        if($this->attributes['permission'] === "*") {
            if(!$this->permissionValues){
                $this->loadPermissionValues();
            }
            return new Permission($this->permissionValues);
        }
        return new Permission($this->attributes['permission']);
    }

    public function loadPermissionValues () {
        $this->permissionValues = PermissionValue::where('namespace',$this->namespace)->get()->pluck('key')->flatten()->toArray();
    }

    public function getPermissionValues () {
        return $this->permissionValues;
    }

}
