<?php
/**
 * Created by PhpStorm.
 * User: amar
 * Date: 2/25/18
 * Time: 12:52 PM
 */

namespace NicoAuth\database\Model;


use Illuminate\Database\Eloquent\Model;
use NicoAuth\NicoAuth;
use NicoAuth\Permission;

/**
 * Class Permission
 * @package NicoAuth\database\Model
 */
class ExplicitPermission extends Model
{

    const MODE_WRITE = 'write';

    const MODE_APPEND = 'append';

    const MODE_REMOVE = 'remove';

    /**
    /**
     * ExplicitPermission constructor.
     * @param array $attributes
     */
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $this->table = NicoAuth::TABLE_USE_EXPLICIT_PERMISSION;
    }

    /**
     * @return Permission
     */
    public function getExplicitPermissionAttribute(){
        return new Permission(array_get($this->attributes,'explicit_permission'));
    }

    /**
     * @return Permission
     */
    public function getGroupPermissionAttribute(){
        return new Permission(array_get($this->attributes,'group_permission'));
    }

}