<?php
/**
 * Created by PhpStorm.
 * User: amar
 * Date: 2/23/18
 * Time: 8:09 PM
 */

namespace NicoAuth;


use NicoAuth\Command\AddPermission;
use NicoAuth\Command\AssignUserPermission;
use NicoAuth\Command\AssignUserPermissionGroup;
use NicoAuth\Command\CreatePermissionGroup;
use NicoAuth\Command\PermissionList;

class ServiceProvider extends \Illuminate\Support\ServiceProvider
{
    /**
     * Register
     */
    public function register(){
        $this->mergeConfigFrom(__DIR__."/Config/nicoAuth.php",'nicoAuth');
    }

    /**
     * Boot
     */
    public function boot(){
        $this->loadMigrationsFrom(__DIR__."/database/migrations");

        $this->publishes([__DIR__."/Config/nicoAuth.php"=>config_path('nicoAuth.php')]);
        if($this->app->runningInConsole()){
            $this->commands([
                AddPermission::class,
                AssignUserPermissionGroup::class,
                CreatePermissionGroup::class,
                AssignUserPermission::class,
                PermissionList::class
            ]);
        }
    }
}