<?php
/**
 * Created by PhpStorm.
 * User: amar
 * Date: 2/25/18
 * Time: 10:18 PM
 */

namespace NicoAuth;


use Illuminate\Contracts\Support\Arrayable;
use Illuminate\Contracts\Support\Jsonable;
use NicoAuth\Exceptions\InvalidPermissionValueException;

class Permission implements Jsonable, Arrayable, \Countable
{
    /**
     * @var array|string
     */
    protected $value = "*";

    /**
     * Permission constructor.
     * @param $value
     */
    public function __construct($value)
    {
        $this->setValue($value);
    }

    /**
     * Read permission is need to every other permission that has some sort of edit permission
     */
    protected function addReadPermissionIfNeeded () {
        if($this->value != "*") {
            $editPermissions =collect($this->value)->filter(function ($perm) {
                $explosion = explode(".",$perm);
                $pop = array_pop($explosion);
                return in_array($pop,['create','update','delete']);
            });

            foreach ($editPermissions as $perm) {
                $explosion = explode(".",$perm);
                array_pop($explosion);
                $explosion[] = "read";
                $this->value[] = implode(".",$explosion);
            }
            $this->value = array_unique($this->value);
        }


    }

    /**
     * Set permission value
     * @param $value
     */
    public function setValue($value){

        if($value) {
            if($value instanceof Permission) {
                $value = $value->getValue();
            }
            if($value == '*') {
                $this->value = $value;
            }else {
                if(is_array($value)){
                    $this->value = $value;
                }elseif($value){
                    $value = json_decode($value);
                    if($value===false){
                        throw new InvalidPermissionValueException($value. " ");
                    }

                    //if json is of type stdClass change it to array
                    if(!is_array($value)){
                        $value = array_values(get_object_vars($value));
                    }
                }else{
                    $value = [];
                }
            }
        }else {
            $value = [];
        }

        $this->value = $value;

        $this->addReadPermissionIfNeeded();
    }
    public function getValue(){
        return $this->value;
    }
    /**
     * Check if this permission have the given authority
     * @param $perm
     * @return bool
     */
    public function has($perm){
        if($this->value=='*'){
            return true;
        }
        return in_array($perm,$this->value);
    }

    /**
     * @param array|string $permissions
     */
    public function add($permissions){

        if(!is_array($permissions)){
            $permissions = array($permissions);
        }

        if(!is_array($this->value)){
            $this->value = [];
        }
        $this->value = array_merge($permissions,$this->value);

        $this->value = array_values(array_unique($this->value));
        return $this;
    }

    /**
     * Check if the permission has not the given value
     * @param $perm
     * @return bool
     */
    public function hasNot($perm){
        return !$this->has($perm);
    }

    public function toJson($options = 0)
    {
        $ret = $this->toArray();
        if(is_array($ret)){
            return json_encode($ret);
        }
        return $ret;
    }

    public function toArray()
    {
        if($this->value == "*") {
            return $this->value;
        }
        if(is_array($this->value)) {
            return $this->value;
        }
        return [];
    }

    public function __toString()
    {
        return $this->toJson();
    }
    public function count()
    {
        if(is_array($this->value)) {
            return count($this->value);
        }
        return null;
    }
}