<?php
/**
 * Created by PhpStorm.
 * User: amar
 * Date: 2/23/18
 * Time: 8:22 PM
 */

namespace NicoAuth\Command;


use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use NicoAuth\Exceptions\DuplicatePermissionException;
use NicoAuth\Exceptions\NicoAuthException;
use NicoAuth\NicoAuth;
use Symfony\Component\Console\Helper\TableSeparator;

class PermissionList extends Command
{
    use CommandTrait;
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'nicoAuth:permissions
    {--namespace=all : Namespace to which permissions are limited to. }
    '

    ;
    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = "List permissions";

    /**
     * AddPermission constructor.
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Handle the command
     */
    public function handle(){
        try{
            $namespace = $this->getNamespace(['all']);
            $query = DB::table(NicoAuth::TABLE_PERMISSION);
            if($namespace!='all'){
                $query = DB::table(NicoAuth::TABLE_PERMISSION)->whereNamespace($namespace);
            }
            $rows = $query->select('namespace','key')->orderBy('namespace')->orderBy('key')->get();
            $data = [];
            foreach($rows as $row){
                $data[] = (array)$row;
            }
            $this->table(['namespace','key'],$data);
        }catch (NicoAuthException $exception){
            $this->error($exception->getMessage());
        }
    }

}