<?php
/**
 * Created by PhpStorm.
 * User: amar
 * Date: 2/23/18
 * Time: 8:23 PM
 */

namespace NicoAuth\Command;


use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use NicoAuth\Exceptions\NicoAuthException;
use NicoAuth\NicoAuth;

class CreatePermissionGroup extends Command
{
    use CommandTrait;
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = "nicoAuth:permissionGroup 
                            {name} 
                            {--namespace=app} 
                            {--perm=*} {--namespaceId=-1} 
                            {--mode=write}
                            ";
    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = "Create a permission group.";
    /**
     * @var array
     */
    protected $modes = ['write','remove','drop','append'];

    /**
     * AddPermission constructor.
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Get mode
     * return string
     */
    protected function getMode(){
        $mode = $this->option('mode');
        if(!in_array($mode,$this->modes)){
            throw new NicoAuthException("Invalid modes. Please use one of ".implode('|',$this->modes));
        }
        return $mode;
    }
    /**
     * Get group name
     */
    protected function getGroupName(){
        return $this->argument('name');
    }

    /**
     * Get permission
     * @return string
     */
    protected function getPermission(){
        $permissions = $this->option('perm');
        if(empty($permissions)){
            return '*';
        }
        foreach($permissions as $permission){
            if(DB::table(NicoAuth::TABLE_PERMISSION)->whereNamespace($this->getNamespace())->whereKey($permission)->count()==0){
                throw new NicoAuthException("Permission '$permission' doesn't exist in the namespace '".$this->getNamespace()."'");
            }
        }
        return json_encode($permissions);
    }

    /**
     * Handle the command
     */
    public function handle(){
        try {
            $groupName = $this->getGroupName();
            $mode = $this->getMode();
            $query = DB::table(NicoAuth::TABLE_PERMISSION_GROUP)
                ->whereNamespace($this->getNamespace())
                ->whereNamespaceId($this->getNamespaceId())
                ->whereKey($groupName);
            switch ($mode){
                case 'write':
                case 'append':
                case 'remove':
                    if($query->count()==0 && $mode!='remove'){
                        $query->insert(['key'=>$groupName,
                            'namespace'=>$this->getNamespace(),
                            'namespace_id'=>$this->getNamespaceId(),
                            'permission'=>$this->getPermission()
                        ]);
                    }else{
                        $permission = $this->getPermission();

                        if($mode=='write' || $permission=='*'){
                            $query->update(['permission'=>$permission]);
                        }else{
                            $permission = json_decode($permission);
                            $row = $query->first();
                            //TODO :: previously giving an error on array function for $row->permission
                            $existingPermission=json_decode($row->permission,true);
                            if($mode=='remove'){
                                $permission = json_encode(array_values(array_diff($existingPermission, $permission)));
                            }else{
                                $permission = json_encode(array_values(array_unique(array_merge($permission,$existingPermission))));
                            }
                            $query->update(['permission'=>$permission]);
                        }
                    }
                    break;

                    break;
                case 'drop':
                    if($query->count()>0){
                        $query->delete();
                    }
                    break;
            }
            $this->info('Permission group updated. ');
        }catch (NicoAuthException $exception){
            $this->error($exception->getMessage());
        }
    }

}