<?php
/**
 * Created by PhpStorm.
 * User: amar
 * Date: 2/23/18
 * Time: 10:07 PM
 */

namespace NicoAuth\Command;


use NicoAuth\Exceptions\NicoAuthException;

trait CommandTrait
{
    /**
     * @param array $allow
     * @return mixed
     */
    protected function getNamespace(array $allow = []){
        $namespace = $this->option('namespace');
        $options = $this->getNamespacesFromConfig();
        $options = array_merge($allow,$options);

        if(!in_array($namespace,$options)){
            throw new NicoAuthException("Invalid namespace. Please use values from [".implode(", ",$options)."]");
        }

        return $namespace;
    }

    /**
     * Get the namespace id from options
     * @return int;
     */
    protected function getNamespaceId(){
        if($this->getNamespace()=='app'){
            return null;
        }
        $id = $this->option('namespaceId');
        $className =  config('nicoAuth.providers.'.$this->getNamespace());
        if(!$className){
            throw new NicoAuthException('Model not provided for namespace '."nicoAuth.providers.".$this->getNamespace());
        }else{
            $model = new $className;
        }
        $row = $model->find($id);
        if($row){
            return $row->id;
        }
        throw new NicoAuthException('Invalid namespace id. Cannot find data for given id '.$id.' in table ' . $model->getTable());
    }

    /**
     * @return array
     */
    protected function getNamespacesFromConfig(){
        return ['app'] + config('nicoAuth.namespaces',[]);
    }



}