<?php
/**
 * Created by PhpStorm.
 * User: amar
 * Date: 2/23/18
 * Time: 8:25 PM
 */

namespace NicoAuth\Command;


use Illuminate\Console\Command;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use NicoAuth\AuthManager;
use NicoAuth\database\Model\PermissionGroup;
use NicoAuth\Exceptions\NicoAuthException;
use NicoAuth\NicoAuth;

class AssignUserPermissionGroup extends Command
{
    use CommandTrait;
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'nicoAuth:userGroup 
                            {userEmail} 
                            {--namespace=app}
                            {--remove}
                            ';
    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = "Assign a user to a particular group.";
    /**
     * @var array
     */
    protected $choices = null;

    /**
     * AddPermission constructor.
     */
    public function __construct()
    {
        parent::__construct();
    }
    protected function isRemoveCommand(){
        return $this->option('remove');
    }
    /**
     * Get email
     */
    public function getEmail(){
        return $this->argument('userEmail');
    }
    /**
     * Get the user from the argument
     */
    private function getUser(){
        $userModel = config('nicoAuth.userModel');
        if(!$userModel){
            throw new NicoAuthException("Please specify userModel in nocoAuth.php. If you haven't published the config. Run vendor:publish command to do it. ");
        }
        try{
            $userModel = new $userModel;
        }catch (\Exception $exception){
            throw new NicoAuthException($exception->getMessage());
        }

        $row = $userModel->where('email',$this->getEmail())->first();
        if($row == null){
            throw new NicoAuthException("Cannot find user by email '".$this->getEmail()."'");
        }
        return $row;
    }

    /**
     * Get choices from database according to the namespace specified
     */
    protected function choices(){
        if($this->choices){
            return $this->choices;
        }
        $namespace = $this->getNamespace();
        $rows = DB::table(NicoAuth::TABLE_PERMISSION_GROUP)
                    ->where('namespace',$namespace)
                    ->get();
        if($rows->count()==0){
            throw new NicoAuthException("There are no any permission groups in the given namespace.
            \n\rYou can use nicoAuth:addPermissionGroup to add a permission group to system. 
            ");
        }
        return $this->choices = $rows;
    }

    /**
     * @return array
     */
    protected function getChoices(){
        return $this->choices()->pluck('key')->all();
    }

    /**
     * @param string $choice
     * @return int
     */
    protected function getChoiceId($choice){
        return $this->choices->where('key',$choice)->first()->perm_grp_id;
    }
    /**
     * Handle the command
     */
    public function handle(){
        try {
            $user = $this->getUser();
            $choice = $this->choice("Choose one of the permission group.",$this->getChoices());
            $choiceId = $this->getChoiceId($choice);
            $query = DB::table(NicoAuth::TABLE_USER_PERMISSION_GROUP_PIVOT)->where('user_id',$user->id)->where('permission_group_id',$choiceId);
            if($this->isRemoveCommand()){
                $query->delete();
            }else{
                if($query->count()==0){
                    DB::transaction(function() use ($user,$choiceId,$choice){
                        DB::table(NicoAuth::TABLE_USER_PERMISSION_GROUP_PIVOT)
                            ->insert(['user_id'=>$user->id, 'permission_group_id'=>$choiceId]);
                        //save the permissions from user's table to explicit users' table
                        $auth = new AuthManager($user);
                        $auth->addToPermissionGroup(PermissionGroup::find($choiceId));
                        $this->info("User '".$user->email."' is successfully added to permission group '".$this->getNamespace().".$choice'" );
                    });

                }else{
                    $this->info("The user is already in the group.");
                }
            }


        }catch (NicoAuthException $exception){
            $this->error($exception->getMessage());
        }
    }

}