<?php
/**
 * Created by PhpStorm.
 * User: amar
 * Date: 2/23/18
 * Time: 8:22 PM
 */

namespace NicoAuth\Command;


use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use NicoAuth\Exceptions\DuplicatePermissionException;
use NicoAuth\Exceptions\NicoAuthException;
use NicoAuth\NicoAuth;

class AssignUserPermission extends Command
{
    use CommandTrait;
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'nicoAuth:userPermission {userEmail} 
                            {--namespace=app} 
                            {--perm=*} 
                            {--namespaceId=-1} 
                            {--mode=write : one of values [write, append, remove, drop]}
                            ';
    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = "Assign user explicit permissions.";
    /**
     * The list of mode that command can be executed with
     *
     * @var array $modes
     */
    protected $modes = ['write','append','remove','drop'];

    /**
     * AddPermission constructor.
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Get email
     */
    public function getEmail(){
        return $this->argument('userEmail');
    }
    /**
     * Get the user from the argument
     */
    private function getUser(){
        $userModel = config('nicoAuth.userModel');
        if(!$userModel){
            throw new NicoAuthException("Please specify userModel in nocoAuth.php. If you haven't published the config. Run vendor:publish command to do it. ");
        }
        try{
            $userModel = new $userModel;
        }catch (\Exception $exception){
            throw new NicoAuthException($exception->getMessage());
        }

        $row = $userModel->where('email',$this->getEmail())->first();
        if($row == null){
            throw new NicoAuthException("Cannot find user by email '".$this->getEmail()."'");
        }
        return $row;
    }



    protected function getPermission(){
        $permissions = $this->option('perm');
        foreach($permissions as $permission){
            if(DB::table(NicoAuth::TABLE_PERMISSION)->whereNamespace($this->getNamespace())->whereKey($permission)->count()==0){
                throw new NicoAuthException("Permission '$permission' doesn't exist in the namespace '".$this->getNamespace()."'");
            }
        }
        return json_encode($permissions);
    }

    /**
     * @return string
     */
    protected function getMode(){
        if(!in_array($this->option('mode'),$this->modes)){
            throw new NicoAuthException("Invalid mode values. Please use one of ".implode(', ',$this->modes));
        }
        return $this->option('mode');
    }
    /**
     * Handle the command
     */
    public function handle(){
        try {
            $user = $this->getUser();

            $query = DB::table(NicoAuth::TABLE_USE_EXPLICIT_PERMISSION)->where('user_id',$user->id)
                ->where('namespace',$this->getNamespace());

            if($this->getNamespaceId()==null){
                $query->whereNull('namespace_id');
            }else{
                $query->where('namespace_id',$this->getNamespaceId());
            }
            $count =$query->count();
            switch ($this->getMode()){
                case 'write':
                case 'append':
                    if($count==0){
                        DB::table(NicoAuth::TABLE_USE_EXPLICIT_PERMISSION)
                            ->insert([
                                'user_id'=>$user->id,
                                'namespace'=>$this->getNamespace(),
                                'namespace_id'=>$this->getNamespaceId(),
                                'explicit_permission'=>$this->getPermission(),
                            ]);
                    }else{
                        $permValue = $this->getPermission();
                        if($this->getMode()=='append'){
                            $row = $query->first();
                            $permValue = json_decode($row->value);
                            $permValue = array_values(array_unique(array_merge($permValue,json_decode($this->getPermission()))));
                            $permValue = json_encode($permValue);

                        }
                        $query->update(['explicit_permission'=>$permValue]);
                    }
                    break;
                case 'remove':
                    if($count>0){
                        $row = $query->first();
                        $value = json_decode($row->value);
                        $value = array_values(array_diff($value,json_decode($this->getPermission())));
                        $query->update(['explicit_permission'=>json_encode($value)]);
                    }
                    break;
                case 'drop':
                    if($count>0){
                        $query->update(['explicit_permission'=>json_encode([])]);
                    }
                    break;
            }

            $this->info("User permission operation executed successfully.");

        }catch (NicoAuthException $exception){
            $this->error($exception->getMessage());
        }
    }

}