<?php
/**
 * Created by PhpStorm.
 * User: amar
 * Date: 2/23/18
 * Time: 8:22 PM
 */

namespace NicoAuth\Command;


use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use NicoAuth\Exceptions\DuplicatePermissionException;
use NicoAuth\Exceptions\NicoAuthException;
use NicoAuth\NicoAuth;

class AddPermission extends Command
{
    use CommandTrait;
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'nicoAuth:permission 
    {names* : Names of permission. Recommend permission name would be users.create users.update users.delete and so on.} 
    {--namespace=app : Namespace to which permissions are limited to. }
    {--remove : remove the listed permission }
    '

    ;
    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = "Create/remove a permission.";

    /**
     * AddPermission constructor.
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Check if this command is remove command
     * @return bool
     */
    private function isRemoveCommand(){
        return $this->option('remove');
    }

    /**
     * Get permission names from arguments
     * @return array
     */
    private function getPermissionNames(){
        $names = $this->argument('names');
        if($this->isRemoveCommand()){
            return $names;
        }
        $namespace = $this->getNamespace();
        $rows = DB::table(NicoAuth::TABLE_PERMISSION)->select('namespace','key')->where('namespace',$namespace)
            ->whereIn('key',$names)->get();
        if($rows->count()>0){
            throw new DuplicatePermissionException("",$rows->pluck('key')->all(),$namespace);
        }
        return $names;
    }

    /**
     * Handle the command
     */
    public function handle(){
        try{
            $names = $this->getPermissionNames();
            $namespace = $this->getNamespace();
            $rows = [];

            if($this->isRemoveCommand()){
                DB::table(NicoAuth::TABLE_PERMISSION)->where('namespace',$namespace)->whereIn('key',$names)->delete();
            }else{
                foreach($names as $name){
                    $rows[] = [
                        'namespace'=>$namespace,
                        'key'=>$name,
                        'created_at'=>new Carbon(),
                        'updated_at'=>new Carbon()
                    ];
                }
                DB::table(NicoAuth::TABLE_PERMISSION)->insert($rows);
            }

            $info = 'Permission(s) '.($this->isRemoveCommand()==true?'removed':'added') .' successfully.';
            $this->info($info);
        }catch (NicoAuthException $exception){
            $this->error($exception->getMessage());
        }
    }

}