<?php

use Illuminate\Database\Seeder;
use \Illuminate\Support\Facades\DB;
class PermissionSeeder extends Seeder
{

    /**
     * Auto generated seed file
     *
     * @return void
     */
    public function run()
    {

        $namespaces = ['app', ];
        $prefixes = ['users','publishers','isbn', 'isbn_applications','publisher_prefixes','permission_groups'];
        $permissions = ['create', 'update', 'read', 'delete'];

        DB::table('nico_auth_perms')->delete();

        foreach($namespaces as $namespace) {
            foreach($prefixes as $prefix) {
                foreach($permissions as $permission) {
                    DB::table('nico_auth_perms')
                        ->insert([
                            'namespace' => $namespace,
                            'key' => $prefix . "." . $permission
                        ]);
                }
            }
        }

        $namespace = "app";
        $permissions = ['users.assign_permission_group','users.un_assign_permission_group',
            'isbn_applications.issue_isbn','isbn.commit','isbn_applications.commit','isbn_applications.mark_received','publishers.assign_owner',
        ];

        foreach($permissions as $permission) {
            DB::table('nico_auth_perms')
                ->insert([
                    'namespace' => $namespace,
                    'key' => $permission
                ]);
        }

    }
}
