<?php

use App\System\User\Database\Models\User;
use App\System\User\Database\Scopes\NonRootUser;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use NicoAuth\AuthManager;
use NicoAuth\NicoAuth;

/**
 * Created by PhpStorm.
 * User: rocco
 * Date: 1/28/19
 * Time: 4:23 PM
 */

class PermissionGroupSeeder extends Seeder
{
    /**
     * @return void
     */
    public function run()
    {
        DB::table(NicoAuth::TABLE_USER_PERMISSION_GROUP_PIVOT)->delete();
        DB::table(NicoAuth::TABLE_PERMISSION_GROUP)->delete();
        $this->createAppRootGroup ();
        $this->createAdministratorPermissionGroup();
        $this->createRegisterUserPermissionGroup();

    }

    protected function createAppRootGroup () {

        $group = AuthManager::createPermissionGroup("Rootuser","Rootuser","*","app");
        $user = (new User())->newQueryWithoutScope(NonRootUser::class)
            ->where('email','rootuser@amarlamichhane.com')
            ->first();

        $auth = new AuthManager($user);
        $auth ->addToPermissionGroup($group);


    }

    protected function createAdministratorPermissionGroup () {
        $permissions = DB::table(NicoAuth::TABLE_PERMISSION)
            ->select('key')
            ->where('namespace','app')
            ->pluck('key');
        $group = AuthManager::createPermissionGroup('administrator', 'Super user', $permissions, "app");
        $user = (new User())
            ->where('email','administrator@isbnuser.com.np')
            ->first ();
        $auth = new AuthManager($user);
        $auth -> addToPermissionGroup($group);

        $user = ((new User())->newQueryWithoutScopes())
            ->where('email','superuser@silverlinetech.com')
            ->first ();
        $auth = new AuthManager($user);
        $auth -> addToPermissionGroup($group);
    }

    public function createRegisterUserPermissionGroup () {
        $permissions = [
            'publishers.create','publishers.update',
            'publishers.read','publishers.delete',
            'isbn.read',
            'isbn_applications.read','isbn_applications.create',
            'isbn_applications.update',
            'publisher_prefixes.read', 'users.read'
        ];
        $group = AuthManager::createPermissionGroup('registered_users', 'Registered users', $permissions, "app");
        $user = ((new User())->newQueryWithoutScopes())
            ->where('email','risa.newa@gmail.com')
            ->first ();
        $auth = new AuthManager($user);
        $auth -> addToPermissionGroup($group);
    }



}
