<?php

use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        $this->command->info("Seeding user...");
        $this->call(UserSeeder::class);
        $this->command->info("User seeded.");
        $this->command->info("Seeding prefixes");
        $this->call(PrefixSeeder::class);
        $this->command->info("Prefixes seeded.");
        $this->command->info('Seeding permissions');
        $this->call(PermissionSeeder::class);
        $this->command->info("Permissions seeded");
        $this->command->info("Seeding permission group");
        $this->call(PermissionGroupSeeder::class);
        $this->command->info('Permission groups seeded');
    }
}
