<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateIssuedIsbnsTable extends Migration
{
    use EditorTrait;
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('issued_isbns', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('publisher_id');
            $table->unsignedInteger('isbn_application_id');
            $table->unsignedInteger('publisher_prefix_id') ->nullable();
            $table->unsignedInteger('isbn_number') ->nullable();
            $table->unsignedInteger('readonly') ->nullable();
            $table->date('issued_date') -> nullable();
            $this->editorLogs($table);

            $table->foreign('publisher_id') -> references ('id') -> on ('publishers');
            $table->foreign('isbn_application_id') -> references ('id') -> on('isbn_applications');
            $table->foreign('publisher_prefix_id') -> references ('id') -> on ('publisher_prefixes');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('issued_isbns');
    }
}
