<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePublishersPrefixesTable extends Migration
{
    use EditorTrait;
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('publisher_prefixes', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('publisher_id')  -> nullable();

            $table->string('prefix',10);

            $table->foreign('publisher_id')->references('id')->on('publishers');
            $this->editorLogs($table);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('publisher_prefixes');
    }
}
