<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateIsbnApplicationsTable extends Migration
{
    use EditorTrait;
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('isbn_applications', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('publisher_id') -> nullable();

            $table->date('requested_date') -> nullable();
            $table->unsignedTinyInteger('isbn_type'); // Book, cassette/CD, E-book, Computer Software, Map, MicroFilm/Microfiche, Others
            $table->string('title');
            $table->string('edition') -> nullable();
            $table->string('subject')->nullable();
            $table->string('author_name');
            $table->string ('accession_number')->nullable();
            $table->unsignedTinyInteger('received_status') ->nullable(); // 1 means received
            $table->string('language', 100) -> nullable();
            $table->string('type') -> nullable(); // paperback or hard bound
            $table->string('corporate_author')->nullable();
            $table->string('corporate_author_address')->nullable();
            $table->string('affiliation_author_address')->nullable();
            $table->unsignedInteger('year')->nullable();
            $table->string('preliminary_page')->nullable();
            $table->string('textual_page')->nullable();
            $table->unsignedInteger('number_of_pages')->nullable();
            $table->unsignedInteger('price')->nullable();
            $table->string('call_number')->nullable();
            $table->string('book_number')->nullable();
            $table->string('keywords')->nullable();
            $table->unsignedTinyInteger('illustration_type'); // Chart, Map, Tables, None
            $table->unsignedTinyInteger('illustration_color'); // B/W, Color, None
            $table->unsignedTinyInteger('photo_illustration'); // B/W, color, None
            $table->string('book_cover_url')->nullable();

            $table->string('deposit_slip_url')->nullable();

            $table->unsignedTinyInteger('readonly')->nullable();

            $this->editorLogs($table);

            $table->foreign('publisher_id')->references('id')->on('publishers');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('isbn_applications');
    }
}
