<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUserPermissionGroupPivotTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create(\NicoAuth\NicoAuth::TABLE_USER_PERMISSION_GROUP_PIVOT, function (Blueprint $table) {
            $table->unsignedInteger('user_id');
            $table->unsignedInteger('permission_group_id');
            $table->foreign('user_id')->references('id')->on('users');
            $table->foreign('permission_group_id')->references('perm_grp_id')->on(\NicoAuth\NicoAuth::TABLE_PERMISSION_GROUP);

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists(\NicoAuth\NicoAuth::TABLE_USER_PERMISSION_GROUP_PIVOT);
    }
}
