<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePermissionGroupTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create(\NicoAuth\NicoAuth::TABLE_PERMISSION_GROUP, function (Blueprint $table) {
            $table->increments('perm_grp_id');
            $table->string('namespace')->note('Namespaces will determine which module/sub-module does this permission belongs to. Default is app');
            $table->string('namespace_id')->nullable()->note('If the namespace value is other than app then this namespace id must be supplied.');
            $table->string('key');
            $table->text('permission')->note('This will hold the json formatted string with one exception to * which will denote all root access');
            $table->text('description');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists(\NicoAuth\NicoAuth::TABLE_PERMISSION_GROUP);
    }
}
