<?php

use Faker\Generator as Faker;

/*
|--------------------------------------------------------------------------
| Model Factories
|--------------------------------------------------------------------------
|
| This directory should contain each of the model factory definitions for
| your application. Factories provide a convenient way to generate new
| model instances for testing / seeding your application's database.
|
*/

$factory->define(App\System\User\Database\Models\User::class, function (Faker $faker) {
    return [
        'first_name' => $faker->firstName,
        'last_name' => $faker->lastName,
        'middle_name' => null,
        'username' => $faker->unique()->safeEmail,
        'email' => $faker->unique()->safeEmail,
        'password' => bcrypt('password'), // secret
        'remember_token' => str_random(10),
    ];
});
