<?php
/**
 * Created by PhpStorm.
 * User: Rocco
 * Date: 11/19/2018
 * Time: 10:16 AM
 */

namespace App\System\User\Filter;


use NicoSystem\Filters\BaseFilter;

class UsersFilter extends BaseFilter
{
    /**
     * @param string $name
     */
    public function name($name = '')
    {
        if ($name !== '') {
            $this->builder->where(function ($query) use ($name) {
                $query->orWhere('first_name', 'like', '%' . $name . '%')
                    ->orWhere('last_name', 'like', '%' . $name . '%')
                    ->orWhere('middle_name', 'like', '%' . $name . '%')
                    ->orWhere('email','like','%'.$name.'%');
            });

        }
    }

    /**
     * @param string $name
     */
    public function keyword ($name = '') {
        $this->name($name);
    }

    /**
     * @param string $name
     */
    public function title ($name  = "") {
        $this->name($name);
    }

    /**
     * @param string $email
     */
    public function email($email = "")
    {
        $this->builder->where('email','like','%'.$email.'%');
    }

}