<?php
/**
 * Created by PhpStorm.
 * User: nicore
 * Date: 12/7/18
 * Time: 3:46 PM
 */

namespace App\System\User\Database\Scopes;


use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Scope;
use NicoSystem\Data\Status;

class CanSignInScope implements Scope
{
    public function apply(Builder $builder, Model $model)
    {
        $builder->where($model->qualifyColumn('status'), Status::STATUS_PUBLISHED);
    }
}