<?php
    /**
     * Created by PhpStorm.
     * User: Amar
     * Date: 10/23/2017
     * Time: 4:45 PM
     */

    namespace App\System\User\Database;


    use Illuminate\Auth\Notifications\ResetPassword;
    use Illuminate\Notifications\Messages\MailMessage;

    class ResetPasswordNotification extends ResetPassword
    {
        /**
         * Build the mail representation of the notification.
         *
         * @param  mixed  $notifiable
         * @return \Illuminate\Notifications\Messages\MailMessage
         */
        public function toMail($notifiable)
        {
            $receiver = json_decode($notifiable);

            return (new MailMessage())
                ->subject(trans('reset_password_email.subject'))
                ->view('emails.reset-password',[
                    'url'=>url(route('password.request',['token'=>$this->token],false)."?email=".$receiver->email.'&'.get_scheme_route_query_parameter()),
                    'token'=>$this->token,
                    'title' => trans('reset_password_email.title'),
                    'email'=>$receiver->email,
                    'receiver'=>ucfirst($receiver->first_name),
            ]);
        }
    }