<?php
/**
 * Created by PhpStorm.
 * User: Amar
 * Date: 6/12/2017
 * Time: 7:26 AM
 */

namespace App\System\User\Database\Models;


use NicoSystem\Foundation\Database\BaseModel;

class UserContact extends BaseModel
{
    const TYPE_CURRENT = 'current';

    const TYPE_PERMANENT = 'permanent';

    /**
     * @var array $fillable
     */
    protected $fillable = ['contact_type','city','street','zip_code','country','state','address'];

    /**
     * @param $value
     * @return $this
     */
    public function setContactTypeAttribute($value){

        $this->attributes['contact_type']= $this->getValueForContactType($value);
        return $this;
    }

    /**
     * @param $value
     * @return string
     */
    public function getValueForContactType($value){
        if($value != static::TYPE_CURRENT || $value != static::TYPE_PERMANENT){
            return static::TYPE_CURRENT;
        }
        return $value;
    }

    /**
     * @param array $options
     * @return bool
     */
    public function save(array $options = [])
    {
        $this->attributes['contact_type'] = $this->getValueForContactType(array_get($this->attributes,'contact_type'));
        return parent::save($options);
    }

}