<?php
/**
 * Created by PhpStorm.
 * User: Amar
 * Date: 1/18/2017
 * Time: 11:17 PM
 */

namespace App\System\User\Database\Models;

use App\Events\User\BeforeUserResponse;
use App\System\Site\Database\Models\BaseSite;
use App\System\Site\Database\Models\Reseller;
use App\System\Site\Database\Models\Site;
use App\System\UAC\Database\Models\PermissionGroup;
use App\System\User\Database\Models\Abstracts\AbstractUser;
use App\System\User\Database\Scopes\NonRootUser;
use NicoAuth\Contracts\Authenticatable;
use NicoAuth\database\Traits\NicoAuths;
use NicoAuth\NicoAuth;

class User extends AbstractUser implements Authenticatable
{
    use NicoAuths;
    /**
     * @var array
     */
    protected $sortableColumns=['first_name','last_name','created_at','status'];

    /**
     * @var string
     */
    protected $defaultSortColumn = "first_name";


    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
    }

    /**
     * Boot
     */
    public static function boot()
    {
        parent::boot();
        static::addGlobalScope(new NonRootUser());
    }

    /**
     * User contact
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function contact()
    {
        return $this->hasOne(UserContact::class, 'user_id');
    }

    /**
     * Contact numbers
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function contactNumbers()
    {
        return $this->hasMany(ContactNumber::class, 'user_id');
    }

    /**
     * User attachment
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function attachments()
    {
        return $this->hasMany(UserAttachment::class, 'user_id');
    }


    public function getId()
    {
        return $this->getAttribute($this->getKeyName());
    }

    public function getEmail()
    {
       return $this->getAttribute('email');
    }
}