<?php
/**
 * Created by PhpStorm.
 * User: Amar
 * Date: 6/12/2017
 * Time: 7:31 AM
 */

namespace App\System\User\Database\Models;


use NicoSystem\Foundation\Database\BaseModel;

class ContactNumber extends BaseModel
{
    const TYPE_LANDLINE = 'landline';

    const TYPE_MOBILE = 'mobile';

    const TYPE_FAX  = 'fax';

    /**
     * @var array
     */
    protected $fillable = ['phone_type','number','description'];

    /**
     * @param $value
     * @return $this
     */
    public function setPhoneTypeAttribute($value){

        $this->attributes['phone_type']= $this->getValueForPhoneType($value);
        return $this;
    }

    /**
     * @param $value
     * @return string
     */
    public function getValueForPhoneType($value){
        if($value != static::TYPE_FAX || $value != static::TYPE_LANDLINE || $value!=static::TYPE_MOBILE){
            return static::TYPE_LANDLINE;
        }
        return $value;
    }

    /**
     * @param array $options
     * @return bool
     */
    public function save(array $options = [])
    {
        $this->attributes['phone_type'] = $this->getValueForPhoneType(array_get($this->attributes,'phone_type'));
        return parent::save($options);
    }

}