<?php
/**
 * Created by PhpStorm.
 * User: nicore
 * Date: 12/7/18
 * Time: 3:45 PM
 */

namespace App\System\User\Database\Models;


use App\System\Site\Database\Models\Reseller;
use App\System\Site\Database\Models\Site;
use App\System\UAC\Database\Models\PermissionGroup;
use App\System\User\Database\Models\Abstracts\AbstractUser;
use App\System\User\Database\Scopes\CanSignInScope;
use NicoAuth\Contracts\Authenticatable;
use NicoAuth\database\Traits\NicoAuths;
use NicoAuth\NicoAuth;

class ActiveUser extends AbstractUser implements Authenticatable
{
    use NicoAuths;

    public static function boot()
    {
        parent::boot();
        self::addGlobalScope(new CanSignInScope());
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return mixed
     */
    public function getEmail()
    {
        return $this->email;
    }


}