<?php
/**
 * Created by PhpStorm.
 * User: Amar
 * Date: 1/8/2017
 * Time: 2:13 PM
 */

namespace App\System\User\Database\Models\Abstracts;

use App\System\AppBaseModel;
use App\System\User\Database\ResetPasswordNotification;
use Illuminate\Auth\Authenticatable;
use Illuminate\Foundation\Auth\Access\Authorizable;
use Illuminate\Contracts\Auth\Authenticatable as AuthenticatableContract;
use Illuminate\Contracts\Auth\Access\Authorizable as AuthorizableContract;
use Illuminate\Contracts\Auth\CanResetPassword as CanResetPasswordContract;
use Illuminate\Notifications\Notifiable;
use Laravel\Passport\HasApiTokens;

class AbstractUser extends AppBaseModel  implements
    AuthenticatableContract,
    AuthorizableContract,
    CanResetPasswordContract
{
    use Authenticatable, Authorizable, HasApiTokens, Notifiable;

    /**
     *
     */
    const STATUS_LOCKED=1;

    /**
     *
     */
    const STATUS_UNLOCKED=0;
    /**
     * @var array
     */
    protected $fillable = ['first_name', 'middle_name', 'username', 'last_name', 'email', 'password', 'image_url'];

    /**
     * The table name
     * @var string
     */
    protected $table = "users";

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        $this->addHidden(['remember_token','password']);
    }

    /**
     * Get the e-mail address where password reset links are sent.
     *
     * @return string
     */
    public function getEmailForPasswordReset()
    {
        return $this->email;
    }

    /**
     * Send the password reset notification.
     *
     * @param  string  $token
     * @return void
     */
    public function sendPasswordResetNotification($token)
    {
        $this->notify(new ResetPasswordNotification($token));
    }

    /**
     * Get image url for the user
     * @return string
     */
    public function getImageUrl(){
        $val = $this->getAttribute('image_url');
        if($val!=''){
            if(substr($val,0,4)=='http'){
                return $val;
            }
            return asset('storage'."/".$this->getAttribute('image_url'));
        }
        return asset('app-images/avatar.svg');
    }


    /**
     * @param array $items
     *
     * @return array
     */
    protected function attachAbsoluteImageUrlToImageUrl(array  $items){
        if(!array_key_exists('image_url',$items)){
            return $items;
        }
        $items['image_url'] = $this->getImageUrl();
        return $items;
    }

    public function emailIsConfirmed () {
        return $this->getAttribute('is_locked') == self::STATUS_UNLOCKED;
    }


    public function toArray()
    {
        $items =  parent::toArray();
        return $this->attachAbsoluteImageUrlToImageUrl($items);

    }

}
