<?php
/**
 * Created by PhpStorm.
 * User: rocco
 * Date: 1/8/19
 * Time: 3:10 PM
 */


namespace App\System\UAC\Database\Models;

use App\System\User\Database\Models\User;
use Illuminate\Database\Eloquent\Builder;
use NicoAuth\database\Model\PermissionGroup as BaseModel;
use NicoAuth\NicoAuth;

class PermissionGroup extends  BaseModel{

    /**
     * @var array
     */
    protected $fillable=['key','permission','namespace','namespace_id','description','created_at'];

    /**
     * @var string
     */
    protected $defaultSortColumn = "key";

    /**
     * @var string
     */
    protected $defaultSortOrder = "asc";

    /**
     * @var array
     */
    protected $sortableColumns = ['key','created_at'];
    /**
     * @param Builder $query
     * @param $namespace
     * @return mixed
     */
    public function scopeNamespace(Builder $query, $namespace, $namespaceId=null)
    {
        return $query->whereNamespace($namespace)
            ->where('namespace_id',$namespaceId);
    }


    /**
     * @return \Illuminate\Database\Eloquent\Relations\MorphTo
     */
    public function permissionable()
    {
        return $this->morphTo('permissionGroup','namespace','namespace_id');
    }


    /**
     *
     */
    public function users()
    {
        return $this->belongsToMany(User::class,NicoAuth::TABLE_USER_PERMISSION_GROUP_PIVOT,'permission_group_id','user_id');
    }

}