<?php
/**
 * Created by PhpStorm.
 * User: nicore
 * Date: 11/13/18
 * Time: 12:27 PM
 */

namespace App\System\Traits;


use App\System\Scopes\PermanentlyDeletedScope;
use Illuminate\Database\Eloquent\SoftDeletingScope;

trait PermanentDeletes
{

    /**
     * Boot the soft deleting trait for a model.
     *
     * @return void
     */
    public static function bootPermanentDeletes()
    {
        static::addGlobalScope(new PermanentlyDeletedScope);
    }

    /**
     * Delete permanently
     */
    public function deletePermanently(){
        $this->performPermanentDeleteOnModel();
    }

    /**
     * Perform the actual delete query on this model instance.
     *
     * @return mixed
     */
    protected function performPermanentDeleteOnModel()
    {

        return $this->runPermanentDelete();
    }

    /**
     * Perform the actual delete query on this model instance.
     *
     * @return mixed
     */
    protected function runPermanentDelete()
    {
        $query = $this->newQueryWithoutScope(SoftDeletingScope::class)->where($this->getKeyName(), $this->getKey());

        $time = $this->freshTimestamp();

        $columns = [$this->getPermanentlyDeletedAtColumn() => $this->fromDateTime($time)];

        $this->{$this->getPermanentlyDeletedAtColumn()} = $time;

        if ($this->timestamps && ! is_null($this->getUpdatedAtColumn())) {
            $this->{$this->getUpdatedAtColumn()} = $time;

            $columns[$this->getUpdatedAtColumn()] = $this->fromDateTime($time);
        }

        return $query->update($columns);
    }


    /**
     * Get the name of the "deleted at" column.
     *
     * @return string
     */
    public function getPermanentlyDeletedAtColumn()
    {
        return defined('static::PERMANENTLY_DELETED_AT') ? static::PERMANENTLY_DELETED_AT : 'permanently_deleted_at';
    }

    /**
     * Get the fully qualified "permanently deleted at" column.
     *
     * @return string
     */
    public function getQualifiedPermanentlyDeletedAtColumn()
    {
        return $this->qualifyColumn($this->getPermanentlyDeletedAtColumn());
    }


}