<?php
/**
 * Created by PhpStorm.
 * User: rocco
 * Date: 12/26/18
 * Time: 4:54 PM
 */

namespace App\System\Scopes;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Scope;
use NicoSystem\Data\Status;

class StatusPublishedScope implements Scope
{

    /**
     * Apply the scope to a given Eloquent query builder.
     *
     * @param  \Illuminate\Database\Eloquent\Builder $builder
     * @param  \Illuminate\Database\Eloquent\Model $model
     * @return void
     */
    public function apply(Builder $builder, Model $model)
    {
        $builder->whereStatus(Status::STATUS_PUBLISHED);
    }
}